@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetDiagnosticPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diagnosticId Diagnostic identifier. Must be unique in the current API Management service instance.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetDiagnosticPlainArgs(
    public val diagnosticId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetDiagnosticPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetDiagnosticPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetDiagnosticPlainArgs.builder()
            .diagnosticId(diagnosticId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiagnosticPlainArgs].
 */
@PulumiTagMarker
public class GetDiagnosticPlainArgsBuilder internal constructor() {
    private var diagnosticId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Diagnostic identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("pqgrhuqxrymndmmx")
    public suspend fun diagnosticId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diagnosticId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("liovbiwwbsfbclpp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("jhhasirjxulekupb")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetDiagnosticPlainArgs = GetDiagnosticPlainArgs(
        diagnosticId = diagnosticId ?: throw PulumiNullFieldException("diagnosticId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
