@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetGlobalSchemaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaId Schema id identifier. Must be unique in the current API Management service instance.
 * @property serviceName The name of the API Management service.
 */
public data class GetGlobalSchemaPlainArgs(
    public val resourceGroupName: String,
    public val schemaId: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetGlobalSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetGlobalSchemaPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetGlobalSchemaPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaId(schemaId.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalSchemaPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalSchemaPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var schemaId: String? = null

    private var serviceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pfjmoaesnpewfqnv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schema id identifier. Must be unique in the current API Management service instance.
     */
    @JvmName("wumgdckvqlrwpxxl")
    public suspend fun schemaId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaId = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("krawybxngfjafdna")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetGlobalSchemaPlainArgs = GetGlobalSchemaPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaId = schemaId ?: throw PulumiNullFieldException("schemaId"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
