@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format Policy Export Format.
 * @property policyId The identifier of the Policy.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetPolicyPlainArgs(
    public val format: String? = null,
    public val policyId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetPolicyPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetPolicyPlainArgs.builder()
            .format(format?.let({ args0 -> args0 }))
            .policyId(policyId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyPlainArgsBuilder internal constructor() {
    private var format: String? = null

    private var policyId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Policy Export Format.
     */
    @JvmName("gxixfirwdkmrqjfd")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.format = mapped
    }

    /**
     * @param value The identifier of the Policy.
     */
    @JvmName("fbasuixodyakusin")
    public suspend fun policyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mxeoghqwxmjlovac")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("owfssufptnpvihiw")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetPolicyPlainArgs = GetPolicyPlainArgs(
        format = format,
        policyId = policyId ?: throw PulumiNullFieldException("policyId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
