@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.GetPolicyRestrictionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policyRestrictionId Policy restrictions after an entity level
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class GetPolicyRestrictionPlainArgs(
    public val policyRestrictionId: String,
    public val resourceGroupName: String,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.GetPolicyRestrictionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.GetPolicyRestrictionPlainArgs =
        com.pulumi.azurenative.apimanagement.inputs.GetPolicyRestrictionPlainArgs.builder()
            .policyRestrictionId(policyRestrictionId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyRestrictionPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyRestrictionPlainArgsBuilder internal constructor() {
    private var policyRestrictionId: String? = null

    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    /**
     * @param value Policy restrictions after an entity level
     */
    @JvmName("vdtcseglxfnjlgxb")
    public suspend fun policyRestrictionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyRestrictionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jewpfqprbpkpwurt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("htdpmppgfcrqdpvv")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetPolicyRestrictionPlainArgs = GetPolicyRestrictionPlainArgs(
        policyRestrictionId = policyRestrictionId ?: throw PulumiNullFieldException("policyRestrictionId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
