@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.OAuth2AuthenticationSettingsContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * API OAuth2 Authentication settings details.
 * @property authorizationServerId OAuth authorization server identifier.
 * @property scope operations scope.
 */
public data class OAuth2AuthenticationSettingsContractArgs(
    public val authorizationServerId: Output<String>? = null,
    public val scope: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.OAuth2AuthenticationSettingsContractArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.OAuth2AuthenticationSettingsContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.OAuth2AuthenticationSettingsContractArgs.builder()
            .authorizationServerId(authorizationServerId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OAuth2AuthenticationSettingsContractArgs].
 */
@PulumiTagMarker
public class OAuth2AuthenticationSettingsContractArgsBuilder internal constructor() {
    private var authorizationServerId: Output<String>? = null

    private var scope: Output<String>? = null

    /**
     * @param value OAuth authorization server identifier.
     */
    @JvmName("dpcskxyuclxjujgj")
    public suspend fun authorizationServerId(`value`: Output<String>) {
        this.authorizationServerId = value
    }

    /**
     * @param value operations scope.
     */
    @JvmName("fekshooshhxbujpx")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value OAuth authorization server identifier.
     */
    @JvmName("yvriqraxubyqpcil")
    public suspend fun authorizationServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationServerId = mapped
    }

    /**
     * @param value operations scope.
     */
    @JvmName("vbtqiegioivgtdfo")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): OAuth2AuthenticationSettingsContractArgs =
        OAuth2AuthenticationSettingsContractArgs(
            authorizationServerId = authorizationServerId,
            scope = scope,
        )
}
