@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.OpenIdAuthenticationSettingsContractArgs.builder
import com.pulumi.azurenative.apimanagement.kotlin.enums.BearerTokenSendingMethods
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * API OAuth2 Authentication settings details.
 * @property bearerTokenSendingMethods How to send token to the server.
 * @property openidProviderId OAuth authorization server identifier.
 */
public data class OpenIdAuthenticationSettingsContractArgs(
    public val bearerTokenSendingMethods: Output<List<Either<String, BearerTokenSendingMethods>>>? =
        null,
    public val openidProviderId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.OpenIdAuthenticationSettingsContractArgs> {
    override fun toJava():
        com.pulumi.azurenative.apimanagement.inputs.OpenIdAuthenticationSettingsContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.OpenIdAuthenticationSettingsContractArgs.builder()
            .bearerTokenSendingMethods(
                bearerTokenSendingMethods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .openidProviderId(openidProviderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenIdAuthenticationSettingsContractArgs].
 */
@PulumiTagMarker
public class OpenIdAuthenticationSettingsContractArgsBuilder internal constructor() {
    private var bearerTokenSendingMethods: Output<List<Either<String, BearerTokenSendingMethods>>>? =
        null

    private var openidProviderId: Output<String>? = null

    /**
     * @param value How to send token to the server.
     */
    @JvmName("wbmcgdlsexbvqhdu")
    public suspend
    fun bearerTokenSendingMethods(`value`: Output<List<Either<String, BearerTokenSendingMethods>>>) {
        this.bearerTokenSendingMethods = value
    }

    @JvmName("graofswxmvosgpom")
    public suspend fun bearerTokenSendingMethods(
        vararg
        values: Output<Either<String, BearerTokenSendingMethods>>,
    ) {
        this.bearerTokenSendingMethods = Output.all(values.asList())
    }

    /**
     * @param values How to send token to the server.
     */
    @JvmName("dkrfwjnnwethfrif")
    public suspend
    fun bearerTokenSendingMethods(values: List<Output<Either<String, BearerTokenSendingMethods>>>) {
        this.bearerTokenSendingMethods = Output.all(values)
    }

    /**
     * @param value OAuth authorization server identifier.
     */
    @JvmName("cioshyuvfjptsnsf")
    public suspend fun openidProviderId(`value`: Output<String>) {
        this.openidProviderId = value
    }

    /**
     * @param value How to send token to the server.
     */
    @JvmName("tgrbxstrdgoubuif")
    public suspend
    fun bearerTokenSendingMethods(`value`: List<Either<String, BearerTokenSendingMethods>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bearerTokenSendingMethods = mapped
    }

    /**
     * @param values How to send token to the server.
     */
    @JvmName("qpcdsxqruwtgqwpw")
    public suspend fun bearerTokenSendingMethods(
        vararg
        values: Either<String, BearerTokenSendingMethods>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bearerTokenSendingMethods = mapped
    }

    /**
     * @param value OAuth authorization server identifier.
     */
    @JvmName("bdlnnlgagufujfdl")
    public suspend fun openidProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openidProviderId = mapped
    }

    internal fun build(): OpenIdAuthenticationSettingsContractArgs =
        OpenIdAuthenticationSettingsContractArgs(
            bearerTokenSendingMethods = bearerTokenSendingMethods,
            openidProviderId = openidProviderId,
        )
}
