@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.RequestContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Operation request details.
 * @property description Operation request description.
 * @property headers Collection of operation request headers.
 * @property queryParameters Collection of operation request query parameters.
 * @property representations Collection of operation request representations.
 */
public data class RequestContractArgs(
    public val description: Output<String>? = null,
    public val headers: Output<List<ParameterContractArgs>>? = null,
    public val queryParameters: Output<List<ParameterContractArgs>>? = null,
    public val representations: Output<List<RepresentationContractArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.RequestContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.RequestContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.RequestContractArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .queryParameters(
                queryParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .representations(
                representations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RequestContractArgs].
 */
@PulumiTagMarker
public class RequestContractArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var headers: Output<List<ParameterContractArgs>>? = null

    private var queryParameters: Output<List<ParameterContractArgs>>? = null

    private var representations: Output<List<RepresentationContractArgs>>? = null

    /**
     * @param value Operation request description.
     */
    @JvmName("kucacqbcmohuhrkq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Collection of operation request headers.
     */
    @JvmName("yofwssddkdaxywsf")
    public suspend fun headers(`value`: Output<List<ParameterContractArgs>>) {
        this.headers = value
    }

    @JvmName("ixggpmflhluxlinq")
    public suspend fun headers(vararg values: Output<ParameterContractArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Collection of operation request headers.
     */
    @JvmName("cmjhpnovbeadmadc")
    public suspend fun headers(values: List<Output<ParameterContractArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Collection of operation request query parameters.
     */
    @JvmName("ykenddvekjtvupeb")
    public suspend fun queryParameters(`value`: Output<List<ParameterContractArgs>>) {
        this.queryParameters = value
    }

    @JvmName("okkpxryjfkwwlvvo")
    public suspend fun queryParameters(vararg values: Output<ParameterContractArgs>) {
        this.queryParameters = Output.all(values.asList())
    }

    /**
     * @param values Collection of operation request query parameters.
     */
    @JvmName("jakfnkedxhsehhyt")
    public suspend fun queryParameters(values: List<Output<ParameterContractArgs>>) {
        this.queryParameters = Output.all(values)
    }

    /**
     * @param value Collection of operation request representations.
     */
    @JvmName("bqceffmcjrhrbiyg")
    public suspend fun representations(`value`: Output<List<RepresentationContractArgs>>) {
        this.representations = value
    }

    @JvmName("gqxkwshvvoqjacuk")
    public suspend fun representations(vararg values: Output<RepresentationContractArgs>) {
        this.representations = Output.all(values.asList())
    }

    /**
     * @param values Collection of operation request representations.
     */
    @JvmName("ncxtlrruuvpcpvtd")
    public suspend fun representations(values: List<Output<RepresentationContractArgs>>) {
        this.representations = Output.all(values)
    }

    /**
     * @param value Operation request description.
     */
    @JvmName("kwrruipsgyhyqddy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Collection of operation request headers.
     */
    @JvmName("foxjggoirpqxpxcu")
    public suspend fun headers(`value`: List<ParameterContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Collection of operation request headers.
     */
    @JvmName("vpajjcnlogacaqnu")
    public suspend fun headers(argument: List<suspend ParameterContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Collection of operation request headers.
     */
    @JvmName("hkxbmafryntaeugb")
    public suspend fun headers(vararg argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Collection of operation request headers.
     */
    @JvmName("vhkoeadflvktoyey")
    public suspend fun headers(argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Collection of operation request headers.
     */
    @JvmName("fiwtyvalktpswuvs")
    public suspend fun headers(vararg values: ParameterContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Collection of operation request query parameters.
     */
    @JvmName("mnupuiubcdgbdybm")
    public suspend fun queryParameters(`value`: List<ParameterContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param argument Collection of operation request query parameters.
     */
    @JvmName("jefjfldvffjguaqd")
    public suspend
    fun queryParameters(argument: List<suspend ParameterContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Collection of operation request query parameters.
     */
    @JvmName("ejewcrdhledrpygn")
    public suspend fun queryParameters(
        vararg
        argument: suspend ParameterContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ParameterContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param argument Collection of operation request query parameters.
     */
    @JvmName("snwuapkaojjoxpvt")
    public suspend fun queryParameters(argument: suspend ParameterContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ParameterContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.queryParameters = mapped
    }

    /**
     * @param values Collection of operation request query parameters.
     */
    @JvmName("jjvvryhfudrocmwv")
    public suspend fun queryParameters(vararg values: ParameterContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queryParameters = mapped
    }

    /**
     * @param value Collection of operation request representations.
     */
    @JvmName("hlgxhqxlhlmwemcs")
    public suspend fun representations(`value`: List<RepresentationContractArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.representations = mapped
    }

    /**
     * @param argument Collection of operation request representations.
     */
    @JvmName("dgxridgbeydbklmw")
    public suspend
    fun representations(argument: List<suspend RepresentationContractArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RepresentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.representations = mapped
    }

    /**
     * @param argument Collection of operation request representations.
     */
    @JvmName("gqyxvykiqgbyqtcw")
    public suspend fun representations(
        vararg
        argument: suspend RepresentationContractArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RepresentationContractArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.representations = mapped
    }

    /**
     * @param argument Collection of operation request representations.
     */
    @JvmName("rddljcjwwfemurui")
    public suspend
    fun representations(argument: suspend RepresentationContractArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RepresentationContractArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.representations = mapped
    }

    /**
     * @param values Collection of operation request representations.
     */
    @JvmName("olwisqtbwgnwemnh")
    public suspend fun representations(vararg values: RepresentationContractArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.representations = mapped
    }

    internal fun build(): RequestContractArgs = RequestContractArgs(
        description = description,
        headers = headers,
        queryParameters = queryParameters,
        representations = representations,
    )
}
