@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.UserIdentityContractArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User identity details.
 * @property id Identifier value within provider.
 * @property provider Identity provider name.
 */
public data class UserIdentityContractArgs(
    public val id: Output<String>? = null,
    public val provider: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.UserIdentityContractArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.UserIdentityContractArgs =
        com.pulumi.azurenative.apimanagement.inputs.UserIdentityContractArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .provider(provider?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityContractArgs].
 */
@PulumiTagMarker
public class UserIdentityContractArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var provider: Output<String>? = null

    /**
     * @param value Identifier value within provider.
     */
    @JvmName("vqpylynsfpxcjtpx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Identity provider name.
     */
    @JvmName("aadahbqevnebcsrl")
    public suspend fun provider(`value`: Output<String>) {
        this.provider = value
    }

    /**
     * @param value Identifier value within provider.
     */
    @JvmName("tlaumpxyuhipeedl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Identity provider name.
     */
    @JvmName("fneatnyhoxqtfnik")
    public suspend fun provider(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    internal fun build(): UserIdentityContractArgs = UserIdentityContractArgs(
        id = id,
        provider = provider,
    )
}
