@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.inputs

import com.pulumi.azurenative.apimanagement.inputs.VirtualNetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration of a virtual network to which API Management service is deployed.
 * @property subnetResourceId The full resource ID of a subnet in a virtual network to deploy the API Management service in.
 */
public data class VirtualNetworkConfigurationArgs(
    public val subnetResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.apimanagement.inputs.VirtualNetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.apimanagement.inputs.VirtualNetworkConfigurationArgs =
        com.pulumi.azurenative.apimanagement.inputs.VirtualNetworkConfigurationArgs.builder()
            .subnetResourceId(subnetResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualNetworkConfigurationArgsBuilder internal constructor() {
    private var subnetResourceId: Output<String>? = null

    /**
     * @param value The full resource ID of a subnet in a virtual network to deploy the API Management service in.
     */
    @JvmName("fscigiulprjsmwxk")
    public suspend fun subnetResourceId(`value`: Output<String>) {
        this.subnetResourceId = value
    }

    /**
     * @param value The full resource ID of a subnet in a virtual network to deploy the API Management service in.
     */
    @JvmName("acidqlgwxricthvm")
    public suspend fun subnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetResourceId = mapped
    }

    internal fun build(): VirtualNetworkConfigurationArgs = VirtualNetworkConfigurationArgs(
        subnetResourceId = subnetResourceId,
    )
}
