@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Description of an additional API Management resource location.
 * @property disableGateway Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the gateway in this additional location.
 * @property gatewayRegionalUrl Gateway URL of the API Management service in the Region.
 * @property location The location name of the additional region among Azure Data center regions.
 * @property natGatewayState Property can be used to enable NAT Gateway for this API Management service.
 * @property outboundPublicIPAddresses Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium SKU on stv2 platform.
 * @property platformVersion Compute Platform Version running the service.
 * @property privateIPAddresses Private Static Load Balanced IP addresses of the API Management service which is deployed in an Internal Virtual Network in a particular additional location. Available only for Basic, Standard, Premium and Isolated SKU.
 * @property publicIPAddresses Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard, Premium and Isolated SKU.
 * @property publicIpAddressId Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the location. Supported only for Premium SKU being deployed in Virtual Network.
 * @property sku SKU properties of the API Management service.
 * @property virtualNetworkConfiguration Virtual network configuration for the location.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class AdditionalLocationResponse(
    public val disableGateway: Boolean? = null,
    public val gatewayRegionalUrl: String,
    public val location: String,
    public val natGatewayState: String? = null,
    public val outboundPublicIPAddresses: List<String>,
    public val platformVersion: String,
    public val privateIPAddresses: List<String>,
    public val publicIPAddresses: List<String>,
    public val publicIpAddressId: String? = null,
    public val sku: ApiManagementServiceSkuPropertiesResponse,
    public val virtualNetworkConfiguration: VirtualNetworkConfigurationResponse? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.AdditionalLocationResponse):
            AdditionalLocationResponse = AdditionalLocationResponse(
            disableGateway = javaType.disableGateway().map({ args0 -> args0 }).orElse(null),
            gatewayRegionalUrl = javaType.gatewayRegionalUrl(),
            location = javaType.location(),
            natGatewayState = javaType.natGatewayState().map({ args0 -> args0 }).orElse(null),
            outboundPublicIPAddresses = javaType.outboundPublicIPAddresses().map({ args0 -> args0 }),
            platformVersion = javaType.platformVersion(),
            privateIPAddresses = javaType.privateIPAddresses().map({ args0 -> args0 }),
            publicIPAddresses = javaType.publicIPAddresses().map({ args0 -> args0 }),
            publicIpAddressId = javaType.publicIpAddressId().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.apimanagement.kotlin.outputs.ApiManagementServiceSkuPropertiesResponse.Companion.toKotlin(args0)
            }),
            virtualNetworkConfiguration = javaType.virtualNetworkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.VirtualNetworkConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
