@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of the Backend WebProxy Server to use in the Request to Backend.
 * @property password Password to connect to the WebProxy Server
 * @property url WebProxy Server AbsoluteUri property which includes the entire URI stored in the Uri instance, including all fragments and query strings.
 * @property username Username to connect to the WebProxy server
 */
public data class BackendProxyContractResponse(
    public val password: String? = null,
    public val url: String,
    public val username: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.BackendProxyContractResponse):
            BackendProxyContractResponse = BackendProxyContractResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            url = javaType.url(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
