@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the Service Fabric Type Backend.
 * @property clientCertificateId The client certificate id for the management endpoint.
 * @property clientCertificatethumbprint The client certificate thumbprint for the management endpoint. Will be ignored if certificatesIds are provided
 * @property managementEndpoints The cluster management endpoint.
 * @property maxPartitionResolutionRetries Maximum number of retries while attempting resolve the partition.
 * @property serverCertificateThumbprints Thumbprints of certificates cluster management service uses for tls communication
 * @property serverX509Names Server X509 Certificate Names Collection
 */
public data class BackendServiceFabricClusterPropertiesResponse(
    public val clientCertificateId: String? = null,
    public val clientCertificatethumbprint: String? = null,
    public val managementEndpoints: List<String>,
    public val maxPartitionResolutionRetries: Int? = null,
    public val serverCertificateThumbprints: List<String>? = null,
    public val serverX509Names: List<X509CertificateNameResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.BackendServiceFabricClusterPropertiesResponse):
            BackendServiceFabricClusterPropertiesResponse =
            BackendServiceFabricClusterPropertiesResponse(
                clientCertificateId = javaType.clientCertificateId().map({ args0 -> args0 }).orElse(null),
                clientCertificatethumbprint = javaType.clientCertificatethumbprint().map({ args0 ->
                    args0
                }).orElse(null),
                managementEndpoints = javaType.managementEndpoints().map({ args0 -> args0 }),
                maxPartitionResolutionRetries = javaType.maxPartitionResolutionRetries().map({ args0 ->
                    args0
                }).orElse(null),
                serverCertificateThumbprints = javaType.serverCertificateThumbprints().map({ args0 -> args0 }),
                serverX509Names = javaType.serverX509Names().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.apimanagement.kotlin.outputs.X509CertificateNameResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
