@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Certificate configuration which consist of non-trusted intermediates and root certificates.
 * @property certificate Certificate information.
 * @property certificatePassword Certificate Password.
 * @property encodedCertificate Base64 Encoded certificate.
 * @property storeName The System.Security.Cryptography.x509certificates.StoreName certificate store location. Only Root and CertificateAuthority are valid locations.
 */
public data class CertificateConfigurationResponse(
    public val certificate: CertificateInformationResponse? = null,
    public val certificatePassword: String? = null,
    public val encodedCertificate: String? = null,
    public val storeName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.CertificateConfigurationResponse):
            CertificateConfigurationResponse = CertificateConfigurationResponse(
            certificate = javaType.certificate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.CertificateInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            certificatePassword = javaType.certificatePassword().map({ args0 -> args0 }).orElse(null),
            encodedCertificate = javaType.encodedCertificate().map({ args0 -> args0 }).orElse(null),
            storeName = javaType.storeName(),
        )
    }
}
