@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SSL certificate information.
 * @property expiry Expiration date of the certificate. The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
 * @property subject Subject of the certificate.
 * @property thumbprint Thumbprint of the certificate.
 */
public data class CertificateInformationResponse(
    public val expiry: String,
    public val subject: String,
    public val thumbprint: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.CertificateInformationResponse):
            CertificateInformationResponse = CertificateInformationResponse(
            expiry = javaType.expiry(),
            subject = javaType.subject(),
            thumbprint = javaType.thumbprint(),
        )
    }
}
