@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Authorization contract.
 * @property authorizationType Authorization type options
 * @property error Authorization error details.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property oAuth2GrantType OAuth2 grant type options
 * @property parameters Authorization parameters
 * @property status Status of the Authorization
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAuthorizationResult(
    public val authorizationType: String? = null,
    public val error: AuthorizationErrorResponse? = null,
    public val id: String,
    public val name: String,
    public val oAuth2GrantType: String? = null,
    public val parameters: Map<String, String>? = null,
    public val status: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetAuthorizationResult):
            GetAuthorizationResult = GetAuthorizationResult(
            authorizationType = javaType.authorizationType().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.apimanagement.kotlin.outputs.AuthorizationErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            oAuth2GrantType = javaType.oAuth2GrantType().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
