@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Content type contract details.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property properties Properties of the content item.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContentItemResult(
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetContentItemResult):
            GetContentItemResult = GetContentItemResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            type = javaType.type(),
        )
    }
}
