@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.apimanagement.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * OpenId Connect Provider details.
 * @property clientId Client ID of developer console which is the client application.
 * @property clientSecret Client Secret of developer console which is the client application.
 * @property description User-friendly description of OpenID Connect Provider.
 * @property displayName User-friendly OpenID Connect Provider name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property metadataEndpoint Metadata endpoint URI.
 * @property name The name of the resource
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property useInApiDocumentation If true, the Open ID Connect provider will be used in the API documentation in the developer portal. False by default if no value is provided.
 * @property useInTestConsole If true, the Open ID Connect provider may be used in the developer portal test console. True by default if no value is provided.
 */
public data class GetOpenIdConnectProviderResult(
    public val clientId: String,
    public val clientSecret: String? = null,
    public val description: String? = null,
    public val displayName: String,
    public val id: String,
    public val metadataEndpoint: String,
    public val name: String,
    public val type: String,
    public val useInApiDocumentation: Boolean? = null,
    public val useInTestConsole: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.apimanagement.outputs.GetOpenIdConnectProviderResult):
            GetOpenIdConnectProviderResult = GetOpenIdConnectProviderResult(
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            id = javaType.id(),
            metadataEndpoint = javaType.metadataEndpoint(),
            name = javaType.name(),
            type = javaType.type(),
            useInApiDocumentation = javaType.useInApiDocumentation().map({ args0 -> args0 }).orElse(null),
            useInTestConsole = javaType.useInTestConsole().map({ args0 -> args0 }).orElse(null),
        )
    }
}
