@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.DaprMetadataResponse
import com.pulumi.azurenative.app.kotlin.outputs.SecretResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.app.kotlin.outputs.DaprMetadataResponse.Companion.toKotlin as daprMetadataResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SecretResponse.Companion.toKotlin as secretResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DaprComponent].
 */
@PulumiTagMarker
public class DaprComponentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DaprComponentArgs = DaprComponentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DaprComponentArgsBuilder.() -> Unit) {
        val builder = DaprComponentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DaprComponent {
        val builtJavaResource = com.pulumi.azurenative.app.DaprComponent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DaprComponent(builtJavaResource)
    }
}

/**
 * Dapr Component.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or update dapr component with secret store component
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponent = new AzureNative.App.DaprComponent("daprComponent", new()
 *     {
 *         ComponentName = "reddog",
 *         ComponentType = "state.azure.cosmosdb",
 *         EnvironmentName = "myenvironment",
 *         IgnoreErrors = false,
 *         InitTimeout = "50s",
 *         Metadata = new[]
 *         {
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "url",
 *                 Value = "<COSMOS-URL>",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "database",
 *                 Value = "itemsDB",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "collection",
 *                 Value = "items",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "masterkey",
 *                 SecretRef = "masterkey",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         Scopes = new[]
 *         {
 *             "container-app-1",
 *             "container-app-2",
 *         },
 *         SecretStoreComponent = "my-secret-store",
 *         Version = "v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprComponent(ctx, "daprComponent", &app.DaprComponentArgs{
 * 			ComponentName:   pulumi.String("reddog"),
 * 			ComponentType:   pulumi.String("state.azure.cosmosdb"),
 * 			EnvironmentName: pulumi.String("myenvironment"),
 * 			IgnoreErrors:    pulumi.Bool(false),
 * 			InitTimeout:     pulumi.String("50s"),
 * 			Metadata: []app.DaprMetadataArgs{
 * 				{
 * 					Name:  pulumi.String("url"),
 * 					Value: pulumi.String("<COSMOS-URL>"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("database"),
 * 					Value: pulumi.String("itemsDB"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("collection"),
 * 					Value: pulumi.String("items"),
 * 				},
 * 				{
 * 					Name:      pulumi.String("masterkey"),
 * 					SecretRef: pulumi.String("masterkey"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("container-app-1"),
 * 				pulumi.String("container-app-2"),
 * 			},
 * 			SecretStoreComponent: pulumi.String("my-secret-store"),
 * 			Version:              pulumi.String("v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponent;
 * import com.pulumi.azurenative.app.DaprComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponent = new DaprComponent("daprComponent", DaprComponentArgs.builder()
 *             .componentName("reddog")
 *             .componentType("state.azure.cosmosdb")
 *             .environmentName("myenvironment")
 *             .ignoreErrors(false)
 *             .initTimeout("50s")
 *             .metadata(
 *                 Map.ofEntries(
 *                     Map.entry("name", "url"),
 *                     Map.entry("value", "<COSMOS-URL>")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "database"),
 *                     Map.entry("value", "itemsDB")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "collection"),
 *                     Map.entry("value", "items")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "masterkey"),
 *                     Map.entry("secretRef", "masterkey")
 *                 ))
 *             .resourceGroupName("examplerg")
 *             .scopes(
 *                 "container-app-1",
 *                 "container-app-2")
 *             .secretStoreComponent("my-secret-store")
 *             .version("v1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update dapr component with secrets
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var daprComponent = new AzureNative.App.DaprComponent("daprComponent", new()
 *     {
 *         ComponentName = "reddog",
 *         ComponentType = "state.azure.cosmosdb",
 *         EnvironmentName = "myenvironment",
 *         IgnoreErrors = false,
 *         InitTimeout = "50s",
 *         Metadata = new[]
 *         {
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "url",
 *                 Value = "<COSMOS-URL>",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "database",
 *                 Value = "itemsDB",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "collection",
 *                 Value = "items",
 *             },
 *             new AzureNative.App.Inputs.DaprMetadataArgs
 *             {
 *                 Name = "masterkey",
 *                 SecretRef = "masterkey",
 *             },
 *         },
 *         ResourceGroupName = "examplerg",
 *         Scopes = new[]
 *         {
 *             "container-app-1",
 *             "container-app-2",
 *         },
 *         Secrets = new[]
 *         {
 *             new AzureNative.App.Inputs.SecretArgs
 *             {
 *                 Name = "masterkey",
 *                 Value = "keyvalue",
 *             },
 *         },
 *         Version = "v1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewDaprComponent(ctx, "daprComponent", &app.DaprComponentArgs{
 * 			ComponentName:   pulumi.String("reddog"),
 * 			ComponentType:   pulumi.String("state.azure.cosmosdb"),
 * 			EnvironmentName: pulumi.String("myenvironment"),
 * 			IgnoreErrors:    pulumi.Bool(false),
 * 			InitTimeout:     pulumi.String("50s"),
 * 			Metadata: []app.DaprMetadataArgs{
 * 				{
 * 					Name:  pulumi.String("url"),
 * 					Value: pulumi.String("<COSMOS-URL>"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("database"),
 * 					Value: pulumi.String("itemsDB"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("collection"),
 * 					Value: pulumi.String("items"),
 * 				},
 * 				{
 * 					Name:      pulumi.String("masterkey"),
 * 					SecretRef: pulumi.String("masterkey"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("container-app-1"),
 * 				pulumi.String("container-app-2"),
 * 			},
 * 			Secrets: []app.SecretArgs{
 * 				{
 * 					Name:  pulumi.String("masterkey"),
 * 					Value: pulumi.String("keyvalue"),
 * 				},
 * 			},
 * 			Version: pulumi.String("v1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.DaprComponent;
 * import com.pulumi.azurenative.app.DaprComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var daprComponent = new DaprComponent("daprComponent", DaprComponentArgs.builder()
 *             .componentName("reddog")
 *             .componentType("state.azure.cosmosdb")
 *             .environmentName("myenvironment")
 *             .ignoreErrors(false)
 *             .initTimeout("50s")
 *             .metadata(
 *                 Map.ofEntries(
 *                     Map.entry("name", "url"),
 *                     Map.entry("value", "<COSMOS-URL>")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "database"),
 *                     Map.entry("value", "itemsDB")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "collection"),
 *                     Map.entry("value", "items")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "masterkey"),
 *                     Map.entry("secretRef", "masterkey")
 *                 ))
 *             .resourceGroupName("examplerg")
 *             .scopes(
 *                 "container-app-1",
 *                 "container-app-2")
 *             .secrets(Map.ofEntries(
 *                 Map.entry("name", "masterkey"),
 *                 Map.entry("value", "keyvalue")
 *             ))
 *             .version("v1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:DaprComponent reddog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/daprComponents/{componentName}
 * ```
 */
public class DaprComponent internal constructor(
    override val javaResource: com.pulumi.azurenative.app.DaprComponent,
) : KotlinCustomResource(javaResource, DaprComponentMapper) {
    /**
     * Component type
     */
    public val componentType: Output<String>?
        get() = javaResource.componentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Boolean describing if the component errors are ignores
     */
    public val ignoreErrors: Output<Boolean>?
        get() = javaResource.ignoreErrors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Initialization timeout
     */
    public val initTimeout: Output<String>?
        get() = javaResource.initTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Component metadata
     */
    public val metadata: Output<List<DaprMetadataResponse>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> daprMetadataResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Names of container apps that can use this Dapr component
     */
    public val scopes: Output<List<String>>?
        get() = javaResource.scopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of a Dapr component to retrieve component secrets from
     */
    public val secretStoreComponent: Output<String>?
        get() = javaResource.secretStoreComponent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Collection of secrets used by a Dapr component
     */
    public val secrets: Output<List<SecretResponse>>?
        get() = javaResource.secrets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> secretResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Component version
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DaprComponentMapper : ResourceMapper<DaprComponent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.DaprComponent::class == javaResource::class

    override fun map(javaResource: Resource): DaprComponent = DaprComponent(
        javaResource as
            com.pulumi.azurenative.app.DaprComponent,
    )
}

/**
 * @see [DaprComponent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DaprComponent].
 */
public suspend fun daprComponent(
    name: String,
    block: suspend DaprComponentResourceBuilder.() -> Unit,
): DaprComponent {
    val builder = DaprComponentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DaprComponent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun daprComponent(name: String): DaprComponent {
    val builder = DaprComponentResourceBuilder()
    builder.name(name)
    return builder.build()
}
