@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.JobConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.JobTemplateResponse
import com.pulumi.azurenative.app.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.JobConfigurationResponse.Companion.toKotlin as jobConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.JobTemplateResponse.Companion.toKotlin as jobTemplateResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Job].
 */
@PulumiTagMarker
public class JobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobArgs = JobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobArgsBuilder.() -> Unit) {
        val builder = JobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Job {
        val builtJavaResource = com.pulumi.azurenative.app.Job(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Job(builtJavaResource)
    }
}

/**
 * Container App Job
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or Update Container Apps Job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.App.Job("job", new()
 *     {
 *         Configuration = new AzureNative.App.Inputs.JobConfigurationArgs
 *         {
 *             ManualTriggerConfig = new AzureNative.App.Inputs.JobConfigurationManualTriggerConfigArgs
 *             {
 *                 Parallelism = 4,
 *                 ReplicaCompletionCount = 1,
 *             },
 *             ReplicaRetryLimit = 10,
 *             ReplicaTimeout = 10,
 *             TriggerType = "Manual",
 *         },
 *         EnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube",
 *         JobName = "testcontainerappsjob0",
 *         Location = "East US",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.App.Inputs.JobTemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.App.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerappsjob0:v1",
 *                     Name = "testcontainerappsjob0",
 *                     Probes = new[]
 *                     {
 *                         new AzureNative.App.Inputs.ContainerAppProbeArgs
 *                         {
 *                             HttpGet = new AzureNative.App.Inputs.ContainerAppProbeHttpGetArgs
 *                             {
 *                                 HttpHeaders = new[]
 *                                 {
 *                                     new AzureNative.App.Inputs.ContainerAppProbeHttpHeadersArgs
 *                                     {
 *                                         Name = "Custom-Header",
 *                                         Value = "Awesome",
 *                                     },
 *                                 },
 *                                 Path = "/health",
 *                                 Port = 8080,
 *                             },
 *                             InitialDelaySeconds = 5,
 *                             PeriodSeconds = 3,
 *                             Type = "Liveness",
 *                         },
 *                     },
 *                 },
 *             },
 *             InitContainers = new[]
 *             {
 *                 new AzureNative.App.Inputs.InitContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     Image = "repo/testcontainerappsjob0:v4",
 *                     Name = "testinitcontainerAppsJob0",
 *                     Resources = new AzureNative.App.Inputs.ContainerResourcesArgs
 *                     {
 *                         Cpu = 0.5,
 *                         Memory = "1Gi",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewJob(ctx, "job", &app.JobArgs{
 * Configuration: app.JobConfigurationResponse{
 * ManualTriggerConfig: &app.JobConfigurationManualTriggerConfigArgs{
 * Parallelism: pulumi.Int(4),
 * ReplicaCompletionCount: pulumi.Int(1),
 * },
 * ReplicaRetryLimit: pulumi.Int(10),
 * ReplicaTimeout: pulumi.Int(10),
 * TriggerType: pulumi.String("Manual"),
 * },
 * EnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube"),
 * JobName: pulumi.String("testcontainerappsjob0"),
 * Location: pulumi.String("East US"),
 * ResourceGroupName: pulumi.String("rg"),
 * Template: app.JobTemplateResponse{
 * Containers: app.ContainerArray{
 * interface{}{
 * Image: pulumi.String("repo/testcontainerappsjob0:v1"),
 * Name: pulumi.String("testcontainerappsjob0"),
 * Probes: app.ContainerAppProbeArray{
 * interface{}{
 * HttpGet: interface{}{
 * HttpHeaders: app.ContainerAppProbeHttpHeadersArray{
 * &app.ContainerAppProbeHttpHeadersArgs{
 * Name: pulumi.String("Custom-Header"),
 * Value: pulumi.String("Awesome"),
 * },
 * },
 * Path: pulumi.String("/health"),
 * Port: pulumi.Int(8080),
 * },
 * InitialDelaySeconds: pulumi.Int(5),
 * PeriodSeconds: pulumi.Int(3),
 * Type: pulumi.String("Liveness"),
 * },
 * },
 * },
 * },
 * InitContainers: app.InitContainerArray{
 * interface{}{
 * Args: pulumi.StringArray{
 * pulumi.String("-c"),
 * pulumi.String("while true; do echo hello; sleep 10;done"),
 * },
 * Command: pulumi.StringArray{
 * pulumi.String("/bin/sh"),
 * },
 * Image: pulumi.String("repo/testcontainerappsjob0:v4"),
 * Name: pulumi.String("testinitcontainerAppsJob0"),
 * Resources: &app.ContainerResourcesArgs{
 * Cpu: pulumi.Float64(0.5),
 * Memory: pulumi.String("1Gi"),
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Job;
 * import com.pulumi.azurenative.app.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("manualTriggerConfig", Map.ofEntries(
 *                     Map.entry("parallelism", 4),
 *                     Map.entry("replicaCompletionCount", 1)
 *                 )),
 *                 Map.entry("replicaRetryLimit", 10),
 *                 Map.entry("replicaTimeout", 10),
 *                 Map.entry("triggerType", "Manual")
 *             ))
 *             .environmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube")
 *             .jobName("testcontainerappsjob0")
 *             .location("East US")
 *             .resourceGroupName("rg")
 *             .template(Map.ofEntries(
 *                 Map.entry("containers", Map.ofEntries(
 *                     Map.entry("image", "repo/testcontainerappsjob0:v1"),
 *                     Map.entry("name", "testcontainerappsjob0"),
 *                     Map.entry("probes", Map.ofEntries(
 *                         Map.entry("httpGet", Map.ofEntries(
 *                             Map.entry("httpHeaders", Map.ofEntries(
 *                                 Map.entry("name", "Custom-Header"),
 *                                 Map.entry("value", "Awesome")
 *                             )),
 *                             Map.entry("path", "/health"),
 *                             Map.entry("port", 8080)
 *                         )),
 *                         Map.entry("initialDelaySeconds", 5),
 *                         Map.entry("periodSeconds", 3),
 *                         Map.entry("type", "Liveness")
 *                     ))
 *                 )),
 *                 Map.entry("initContainers", Map.ofEntries(
 *                     Map.entry("args",
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done"),
 *                     Map.entry("command", "/bin/sh"),
 *                     Map.entry("image", "repo/testcontainerappsjob0:v4"),
 *                     Map.entry("name", "testinitcontainerAppsJob0"),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("cpu", 0.5),
 *                         Map.entry("memory", "1Gi")
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Container Apps Job With Event Driven Trigger
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.App.Job("job", new()
 *     {
 *         Configuration = new AzureNative.App.Inputs.JobConfigurationArgs
 *         {
 *             EventTriggerConfig = new AzureNative.App.Inputs.JobConfigurationEventTriggerConfigArgs
 *             {
 *                 Parallelism = 4,
 *                 ReplicaCompletionCount = 1,
 *                 Scale = new AzureNative.App.Inputs.JobScaleArgs
 *                 {
 *                     MaxExecutions = 5,
 *                     MinExecutions = 1,
 *                     PollingInterval = 40,
 *                     Rules = new[]
 *                     {
 *                         new AzureNative.App.Inputs.JobScaleRuleArgs
 *                         {
 *                             Metadata =
 *                             {
 *                                 { "topicName", "my-topic" },
 *                             },
 *                             Name = "servicebuscalingrule",
 *                             Type = "azure-servicebus",
 *                         },
 *                     },
 *                 },
 *             },
 *             ReplicaRetryLimit = 10,
 *             ReplicaTimeout = 10,
 *             TriggerType = "Event",
 *         },
 *         EnvironmentId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube",
 *         JobName = "testcontainerappsjob0",
 *         Location = "East US",
 *         ResourceGroupName = "rg",
 *         Template = new AzureNative.App.Inputs.JobTemplateArgs
 *         {
 *             Containers = new[]
 *             {
 *                 new AzureNative.App.Inputs.ContainerArgs
 *                 {
 *                     Image = "repo/testcontainerappsjob0:v1",
 *                     Name = "testcontainerappsjob0",
 *                 },
 *             },
 *             InitContainers = new[]
 *             {
 *                 new AzureNative.App.Inputs.InitContainerArgs
 *                 {
 *                     Args = new[]
 *                     {
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done",
 *                     },
 *                     Command = new[]
 *                     {
 *                         "/bin/sh",
 *                     },
 *                     Image = "repo/testcontainerappsjob0:v4",
 *                     Name = "testinitcontainerAppsJob0",
 *                     Resources = new AzureNative.App.Inputs.ContainerResourcesArgs
 *                     {
 *                         Cpu = 0.5,
 *                         Memory = "1Gi",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := app.NewJob(ctx, "job", &app.JobArgs{
 * Configuration: app.JobConfigurationResponse{
 * EventTriggerConfig: interface{}{
 * Parallelism: pulumi.Int(4),
 * ReplicaCompletionCount: pulumi.Int(1),
 * Scale: interface{}{
 * MaxExecutions: pulumi.Int(5),
 * MinExecutions: pulumi.Int(1),
 * PollingInterval: pulumi.Int(40),
 * Rules: app.JobScaleRuleArray{
 * &app.JobScaleRuleArgs{
 * Metadata: pulumi.Any{
 * TopicName: "my-topic",
 * },
 * Name: pulumi.String("servicebuscalingrule"),
 * Type: pulumi.String("azure-servicebus"),
 * },
 * },
 * },
 * },
 * ReplicaRetryLimit: pulumi.Int(10),
 * ReplicaTimeout: pulumi.Int(10),
 * TriggerType: pulumi.String("Event"),
 * },
 * EnvironmentId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube"),
 * JobName: pulumi.String("testcontainerappsjob0"),
 * Location: pulumi.String("East US"),
 * ResourceGroupName: pulumi.String("rg"),
 * Template: app.JobTemplateResponse{
 * Containers: app.ContainerArray{
 * &app.ContainerArgs{
 * Image: pulumi.String("repo/testcontainerappsjob0:v1"),
 * Name: pulumi.String("testcontainerappsjob0"),
 * },
 * },
 * InitContainers: app.InitContainerArray{
 * interface{}{
 * Args: pulumi.StringArray{
 * pulumi.String("-c"),
 * pulumi.String("while true; do echo hello; sleep 10;done"),
 * },
 * Command: pulumi.StringArray{
 * pulumi.String("/bin/sh"),
 * },
 * Image: pulumi.String("repo/testcontainerappsjob0:v4"),
 * Name: pulumi.String("testinitcontainerAppsJob0"),
 * Resources: &app.ContainerResourcesArgs{
 * Cpu: pulumi.Float64(0.5),
 * Memory: pulumi.String("1Gi"),
 * },
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.Job;
 * import com.pulumi.azurenative.app.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("eventTriggerConfig", Map.ofEntries(
 *                     Map.entry("parallelism", 4),
 *                     Map.entry("replicaCompletionCount", 1),
 *                     Map.entry("scale", Map.ofEntries(
 *                         Map.entry("maxExecutions", 5),
 *                         Map.entry("minExecutions", 1),
 *                         Map.entry("pollingInterval", 40),
 *                         Map.entry("rules", Map.ofEntries(
 *                             Map.entry("metadata", Map.of("topicName", "my-topic")),
 *                             Map.entry("name", "servicebuscalingrule"),
 *                             Map.entry("type", "azure-servicebus")
 *                         ))
 *                     ))
 *                 )),
 *                 Map.entry("replicaRetryLimit", 10),
 *                 Map.entry("replicaTimeout", 10),
 *                 Map.entry("triggerType", "Event")
 *             ))
 *             .environmentId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/rg/providers/Microsoft.App/managedEnvironments/demokube")
 *             .jobName("testcontainerappsjob0")
 *             .location("East US")
 *             .resourceGroupName("rg")
 *             .template(Map.ofEntries(
 *                 Map.entry("containers", Map.ofEntries(
 *                     Map.entry("image", "repo/testcontainerappsjob0:v1"),
 *                     Map.entry("name", "testcontainerappsjob0")
 *                 )),
 *                 Map.entry("initContainers", Map.ofEntries(
 *                     Map.entry("args",
 *                         "-c",
 *                         "while true; do echo hello; sleep 10;done"),
 *                     Map.entry("command", "/bin/sh"),
 *                     Map.entry("image", "repo/testcontainerappsjob0:v4"),
 *                     Map.entry("name", "testinitcontainerAppsJob0"),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("cpu", 0.5),
 *                         Map.entry("memory", "1Gi")
 *                     ))
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:Job testcontainerappsjob0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}
 * ```
 */
public class Job internal constructor(
    override val javaResource: com.pulumi.azurenative.app.Job,
) : KotlinCustomResource(javaResource, JobMapper) {
    /**
     * Container Apps Job configuration properties.
     */
    public val configuration: Output<JobConfigurationResponse>?
        get() = javaResource.configuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jobConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource ID of environment.
     */
    public val environmentId: Output<String>?
        get() = javaResource.environmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The endpoint of the eventstream of the container apps job.
     */
    public val eventStreamEndpoint: Output<String>
        get() = javaResource.eventStreamEndpoint().applyValue({ args0 -> args0 })

    /**
     * Managed identities needed by a container app job to interact with other Azure services to not maintain any secrets or credentials in code.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Outbound IP Addresses of a container apps job.
     */
    public val outboundIpAddresses: Output<List<String>>
        get() = javaResource.outboundIpAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Provisioning state of the Container Apps Job.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Container Apps job definition.
     */
    public val template: Output<JobTemplateResponse>?
        get() = javaResource.template().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    jobTemplateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Workload profile name to pin for container apps job execution.
     */
    public val workloadProfileName: Output<String>?
        get() = javaResource.workloadProfileName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object JobMapper : ResourceMapper<Job> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.Job::class == javaResource::class

    override fun map(javaResource: Resource): Job = Job(
        javaResource as
            com.pulumi.azurenative.app.Job,
    )
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Job].
 */
public suspend fun job(name: String, block: suspend JobResourceBuilder.() -> Unit): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Job].
 * @param name The _unique_ name of the resulting resource.
 */
public fun job(name: String): Job {
    val builder = JobResourceBuilder()
    builder.name(name)
    return builder.build()
}
