@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.ManagedCertificateArgs.builder
import com.pulumi.azurenative.app.kotlin.inputs.ManagedCertificatePropertiesArgs
import com.pulumi.azurenative.app.kotlin.inputs.ManagedCertificatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Managed certificates used for Custom Domain bindings of Container Apps in a Managed Environment
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create or Update Certificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCertificate = new AzureNative.App.ManagedCertificate("managedCertificate", new()
 *     {
 *         EnvironmentName = "testcontainerenv",
 *         Location = "East US",
 *         ManagedCertificateName = "certificate-firendly-name",
 *         Properties = new AzureNative.App.Inputs.ManagedCertificatePropertiesArgs
 *         {
 *             DomainControlValidation = "CNAME",
 *             SubjectName = "my-subject-name.company.country.net",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewManagedCertificate(ctx, "managedCertificate", &app.ManagedCertificateArgs{
 * 			EnvironmentName:        pulumi.String("testcontainerenv"),
 * 			Location:               pulumi.String("East US"),
 * 			ManagedCertificateName: pulumi.String("certificate-firendly-name"),
 * 			Properties: &app.ManagedCertificatePropertiesArgs{
 * 				DomainControlValidation: pulumi.String("CNAME"),
 * 				SubjectName:             pulumi.String("my-subject-name.company.country.net"),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ManagedCertificate;
 * import com.pulumi.azurenative.app.ManagedCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCertificate = new ManagedCertificate("managedCertificate", ManagedCertificateArgs.builder()
 *             .environmentName("testcontainerenv")
 *             .location("East US")
 *             .managedCertificateName("certificate-firendly-name")
 *             .properties(Map.ofEntries(
 *                 Map.entry("domainControlValidation", "CNAME"),
 *                 Map.entry("subjectName", "my-subject-name.company.country.net")
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ManagedCertificate myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}/managedCertificates/{managedCertificateName}
 * ```
 * @property environmentName Name of the Managed Environment.
 * @property location The geo-location where the resource lives
 * @property managedCertificateName Name of the Managed Certificate.
 * @property properties Certificate resource specific properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ManagedCertificateArgs(
    public val environmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedCertificateName: Output<String>? = null,
    public val properties: Output<ManagedCertificatePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.ManagedCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.app.ManagedCertificateArgs =
        com.pulumi.azurenative.app.ManagedCertificateArgs.builder()
            .environmentName(environmentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedCertificateName(managedCertificateName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedCertificateArgs].
 */
@PulumiTagMarker
public class ManagedCertificateArgsBuilder internal constructor() {
    private var environmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var managedCertificateName: Output<String>? = null

    private var properties: Output<ManagedCertificatePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("qgyektwxgnuefedd")
    public suspend fun environmentName(`value`: Output<String>) {
        this.environmentName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("suffidsydboiwpdm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Managed Certificate.
     */
    @JvmName("xnlvgrfnpxnbwjuj")
    public suspend fun managedCertificateName(`value`: Output<String>) {
        this.managedCertificateName = value
    }

    /**
     * @param value Certificate resource specific properties
     */
    @JvmName("thcsgutufnrwhvwv")
    public suspend fun properties(`value`: Output<ManagedCertificatePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsonqmpinpwwnnfs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xtgfoptypgoeeomq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("jwalwbyuftqxalfa")
    public suspend fun environmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dieoylsluviiijkr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Managed Certificate.
     */
    @JvmName("ptpixqkdbhnklvqm")
    public suspend fun managedCertificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedCertificateName = mapped
    }

    /**
     * @param value Certificate resource specific properties
     */
    @JvmName("rynfqsugewchvybd")
    public suspend fun properties(`value`: ManagedCertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Certificate resource specific properties
     */
    @JvmName("btvyjmbihoviiysb")
    public suspend
    fun properties(argument: suspend ManagedCertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedCertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cnxkfuitskcqsjdb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dwmwoinujjrvpoqg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hwcvtjafclafrroh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedCertificateArgs = ManagedCertificateArgs(
        environmentName = environmentName,
        location = location,
        managedCertificateName = managedCertificateName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
