@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin

import com.pulumi.azurenative.app.kotlin.outputs.AppLogsConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.CustomDomainConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.EnvironmentSkuPropertiesResponse
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.app.kotlin.outputs.VnetConfigurationResponse
import com.pulumi.azurenative.app.kotlin.outputs.WorkloadProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.app.kotlin.outputs.AppLogsConfigurationResponse.Companion.toKotlin as appLogsConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.CustomDomainConfigurationResponse.Companion.toKotlin as customDomainConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.EnvironmentSkuPropertiesResponse.Companion.toKotlin as environmentSkuPropertiesResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.VnetConfigurationResponse.Companion.toKotlin as vnetConfigurationResponseToKotlin
import com.pulumi.azurenative.app.kotlin.outputs.WorkloadProfileResponse.Companion.toKotlin as workloadProfileResponseToKotlin

/**
 * Builder for [ManagedEnvironment].
 */
@PulumiTagMarker
public class ManagedEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedEnvironmentArgs = ManagedEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedEnvironmentArgsBuilder.() -> Unit) {
        val builder = ManagedEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedEnvironment {
        val builtJavaResource = com.pulumi.azurenative.app.ManagedEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedEnvironment(builtJavaResource)
    }
}

/**
 * An environment for hosting container apps
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2022-03-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-05-01, 2023-05-02-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### Create environments
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedEnvironment = new AzureNative.App.ManagedEnvironment("managedEnvironment", new()
 *     {
 *         AppLogsConfiguration = new AzureNative.App.Inputs.AppLogsConfigurationArgs
 *         {
 *             LogAnalyticsConfiguration = new AzureNative.App.Inputs.LogAnalyticsConfigurationArgs
 *             {
 *                 CustomerId = "string",
 *                 SharedKey = "string",
 *             },
 *         },
 *         CustomDomainConfiguration = new AzureNative.App.Inputs.CustomDomainConfigurationArgs
 *         {
 *             CertificatePassword = "private key password",
 *             CertificateValue = "Y2VydA==",
 *             DnsSuffix = "www.my-name.com",
 *         },
 *         DaprAIConnectionString = "InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/",
 *         EnvironmentName = "testcontainerenv",
 *         Kind = "serverless",
 *         Location = "East US",
 *         ResourceGroupName = "examplerg",
 *         Sku = new AzureNative.App.Inputs.EnvironmentSkuPropertiesArgs
 *         {
 *             Name = "Premium",
 *         },
 *         VnetConfiguration = new AzureNative.App.Inputs.VnetConfigurationArgs
 *         {
 *             OutboundSettings = new AzureNative.App.Inputs.ManagedEnvironmentOutboundSettingsArgs
 *             {
 *                 OutBoundType = "UserDefinedRouting",
 *                 VirtualNetworkApplianceIp = "192.168.1.20",
 *             },
 *         },
 *         WorkloadProfiles = new[]
 *         {
 *             new AzureNative.App.Inputs.WorkloadProfileArgs
 *             {
 *                 MaximumCount = 12,
 *                 MinimumCount = 3,
 *                 WorkloadProfileType = "GeneralPurpose",
 *             },
 *             new AzureNative.App.Inputs.WorkloadProfileArgs
 *             {
 *                 MaximumCount = 6,
 *                 MinimumCount = 3,
 *                 WorkloadProfileType = "MemoryOptimized",
 *             },
 *             new AzureNative.App.Inputs.WorkloadProfileArgs
 *             {
 *                 MaximumCount = 6,
 *                 MinimumCount = 3,
 *                 WorkloadProfileType = "ComputeOptimized",
 *             },
 *         },
 *         ZoneRedundant = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/app/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := app.NewManagedEnvironment(ctx, "managedEnvironment", &app.ManagedEnvironmentArgs{
 * 			AppLogsConfiguration: app.AppLogsConfigurationResponse{
 * 				LogAnalyticsConfiguration: &app.LogAnalyticsConfigurationArgs{
 * 					CustomerId: pulumi.String("string"),
 * 					SharedKey:  pulumi.String("string"),
 * 				},
 * 			},
 * 			CustomDomainConfiguration: &app.CustomDomainConfigurationArgs{
 * 				CertificatePassword: pulumi.String("private key password"),
 * 				CertificateValue:    pulumi.String("Y2VydA=="),
 * 				DnsSuffix:           pulumi.String("www.my-name.com"),
 * 			},
 * 			DaprAIConnectionString: pulumi.String("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/"),
 * 			EnvironmentName:        pulumi.String("testcontainerenv"),
 * 			Kind:                   pulumi.String("serverless"),
 * 			Location:               pulumi.String("East US"),
 * 			ResourceGroupName:      pulumi.String("examplerg"),
 * 			Sku: &app.EnvironmentSkuPropertiesArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 			VnetConfiguration: app.VnetConfigurationResponse{
 * 				OutboundSettings: &app.ManagedEnvironmentOutboundSettingsArgs{
 * 					OutBoundType:              pulumi.String("UserDefinedRouting"),
 * 					VirtualNetworkApplianceIp: pulumi.String("192.168.1.20"),
 * 				},
 * 			},
 * 			WorkloadProfiles: []app.WorkloadProfileArgs{
 * 				{
 * 					MaximumCount:        pulumi.Int(12),
 * 					MinimumCount:        pulumi.Int(3),
 * 					WorkloadProfileType: pulumi.String("GeneralPurpose"),
 * 				},
 * 				{
 * 					MaximumCount:        pulumi.Int(6),
 * 					MinimumCount:        pulumi.Int(3),
 * 					WorkloadProfileType: pulumi.String("MemoryOptimized"),
 * 				},
 * 				{
 * 					MaximumCount:        pulumi.Int(6),
 * 					MinimumCount:        pulumi.Int(3),
 * 					WorkloadProfileType: pulumi.String("ComputeOptimized"),
 * 				},
 * 			},
 * 			ZoneRedundant: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.app.ManagedEnvironment;
 * import com.pulumi.azurenative.app.ManagedEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedEnvironment = new ManagedEnvironment("managedEnvironment", ManagedEnvironmentArgs.builder()
 *             .appLogsConfiguration(Map.of("logAnalyticsConfiguration", Map.ofEntries(
 *                 Map.entry("customerId", "string"),
 *                 Map.entry("sharedKey", "string")
 *             )))
 *             .customDomainConfiguration(Map.ofEntries(
 *                 Map.entry("certificatePassword", "private key password"),
 *                 Map.entry("certificateValue", "Y2VydA=="),
 *                 Map.entry("dnsSuffix", "www.my-name.com")
 *             ))
 *             .daprAIConnectionString("InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/")
 *             .environmentName("testcontainerenv")
 *             .kind("serverless")
 *             .location("East US")
 *             .resourceGroupName("examplerg")
 *             .sku(Map.of("name", "Premium"))
 *             .vnetConfiguration(Map.of("outboundSettings", Map.ofEntries(
 *                 Map.entry("outBoundType", "UserDefinedRouting"),
 *                 Map.entry("virtualNetworkApplianceIp", "192.168.1.20")
 *             )))
 *             .workloadProfiles(
 *                 Map.ofEntries(
 *                     Map.entry("maximumCount", 12),
 *                     Map.entry("minimumCount", 3),
 *                     Map.entry("workloadProfileType", "GeneralPurpose")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("maximumCount", 6),
 *                     Map.entry("minimumCount", 3),
 *                     Map.entry("workloadProfileType", "MemoryOptimized")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("maximumCount", 6),
 *                     Map.entry("minimumCount", 3),
 *                     Map.entry("workloadProfileType", "ComputeOptimized")
 *                 ))
 *             .zoneRedundant(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:app:ManagedEnvironment testcontainerenv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/managedEnvironments/{environmentName}
 * ```
 */
public class ManagedEnvironment internal constructor(
    override val javaResource: com.pulumi.azurenative.app.ManagedEnvironment,
) : KotlinCustomResource(javaResource, ManagedEnvironmentMapper) {
    /**
     * Cluster configuration which enables the log daemon to export
     * app logs to a destination. Currently only "log-analytics" is
     * supported
     */
    public val appLogsConfiguration: Output<AppLogsConfigurationResponse>?
        get() = javaResource.appLogsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> appLogsConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Custom domain configuration for the environment
     */
    public val customDomainConfiguration: Output<CustomDomainConfigurationResponse>?
        get() = javaResource.customDomainConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> customDomainConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Application Insights connection string used by Dapr to export Service to Service communication telemetry
     */
    public val daprAIConnectionString: Output<String>?
        get() = javaResource.daprAIConnectionString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
     */
    public val daprAIInstrumentationKey: Output<String>?
        get() = javaResource.daprAIInstrumentationKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Default Domain Name for the cluster
     */
    public val defaultDomain: Output<String>
        get() = javaResource.defaultDomain().applyValue({ args0 -> args0 })

    /**
     * Any errors that occurred during deployment or deployment validation
     */
    public val deploymentErrors: Output<String>
        get() = javaResource.deploymentErrors().applyValue({ args0 -> args0 })

    /**
     * The endpoint of the eventstream of the Environment.
     */
    public val eventStreamEndpoint: Output<String>
        get() = javaResource.eventStreamEndpoint().applyValue({ args0 -> args0 })

    /**
     * Kind of the Environment.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the Environment.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SKU properties of the Environment.
     */
    public val sku: Output<EnvironmentSkuPropertiesResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    environmentSkuPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Static IP of the Environment
     */
    public val staticIp: Output<String>
        get() = javaResource.staticIp().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Vnet configuration for the environment
     */
    public val vnetConfiguration: Output<VnetConfigurationResponse>?
        get() = javaResource.vnetConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> vnetConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Workload profiles configured for the Managed Environment.
     */
    public val workloadProfiles: Output<List<WorkloadProfileResponse>>?
        get() = javaResource.workloadProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        workloadProfileResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Whether or not this Managed Environment is zone-redundant.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ManagedEnvironmentMapper : ResourceMapper<ManagedEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.app.ManagedEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): ManagedEnvironment = ManagedEnvironment(
        javaResource as
            com.pulumi.azurenative.app.ManagedEnvironment,
    )
}

/**
 * @see [ManagedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedEnvironment].
 */
public suspend fun managedEnvironment(
    name: String,
    block: suspend ManagedEnvironmentResourceBuilder.() -> Unit,
): ManagedEnvironment {
    val builder = ManagedEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedEnvironment(name: String): ManagedEnvironment {
    val builder = ManagedEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
