@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
 */
public enum class AppProtocol(
    public val javaValue: com.pulumi.azurenative.app.enums.AppProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.AppProtocol> {
    Http(com.pulumi.azurenative.app.enums.AppProtocol.Http),
    Grpc(com.pulumi.azurenative.app.enums.AppProtocol.Grpc),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.AppProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.AppProtocol): AppProtocol =
            AppProtocol.values().first { it.javaValue == javaType }
    }
}
