@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Custom Domain binding type.
 */
public enum class BindingType(
    public val javaValue: com.pulumi.azurenative.app.enums.BindingType,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.BindingType> {
    Disabled(com.pulumi.azurenative.app.enums.BindingType.Disabled),
    SniEnabled(com.pulumi.azurenative.app.enums.BindingType.SniEnabled),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.BindingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.BindingType): BindingType =
            BindingType.values().first { it.javaValue == javaType }
    }
}
