@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The convention used when determining the session cookie's expiration.
 */
public enum class CookieExpirationConvention(
    public val javaValue: com.pulumi.azurenative.app.enums.CookieExpirationConvention,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.CookieExpirationConvention> {
    FixedTime(com.pulumi.azurenative.app.enums.CookieExpirationConvention.FixedTime),
    IdentityProviderDerived(com.pulumi.azurenative.app.enums.CookieExpirationConvention.IdentityProviderDerived),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.CookieExpirationConvention = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.CookieExpirationConvention):
            CookieExpirationConvention =
            CookieExpirationConvention.values().first { it.javaValue == javaType }
    }
}
