@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of probe.
 */
public enum class Type(
    public val javaValue: com.pulumi.azurenative.app.enums.Type,
) : ConvertibleToJava<com.pulumi.azurenative.app.enums.Type> {
    Liveness(com.pulumi.azurenative.app.enums.Type.Liveness),
    Readiness(com.pulumi.azurenative.app.enums.Type.Readiness),
    Startup(com.pulumi.azurenative.app.enums.Type.Startup),
    ;

    override fun toJava(): com.pulumi.azurenative.app.enums.Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.enums.Type): Type =
            Type.values().first { it.javaValue == javaType }
    }
}
