@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.BuildConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration of the build.
 * @property baseOs Base OS used to build and run the app.
 * @property environmentVariables List of environment variables to be passed to the build.
 * @property platform Platform to be used to build and run the app.
 * @property platformVersion Platform version to be used to build and run the app.
 * @property preBuildSteps List of steps to perform before the build.
 */
public data class BuildConfigurationArgs(
    public val baseOs: Output<String>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val platform: Output<String>? = null,
    public val platformVersion: Output<String>? = null,
    public val preBuildSteps: Output<List<PreBuildStepArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.BuildConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.BuildConfigurationArgs =
        com.pulumi.azurenative.app.inputs.BuildConfigurationArgs.builder()
            .baseOs(baseOs?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .platform(platform?.applyValue({ args0 -> args0 }))
            .platformVersion(platformVersion?.applyValue({ args0 -> args0 }))
            .preBuildSteps(
                preBuildSteps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BuildConfigurationArgs].
 */
@PulumiTagMarker
public class BuildConfigurationArgsBuilder internal constructor() {
    private var baseOs: Output<String>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var platform: Output<String>? = null

    private var platformVersion: Output<String>? = null

    private var preBuildSteps: Output<List<PreBuildStepArgs>>? = null

    /**
     * @param value Base OS used to build and run the app.
     */
    @JvmName("ctwvsxugopyqljsx")
    public suspend fun baseOs(`value`: Output<String>) {
        this.baseOs = value
    }

    /**
     * @param value List of environment variables to be passed to the build.
     */
    @JvmName("bokwrrooiwygwrsa")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("juwwvxfclxdelijv")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values List of environment variables to be passed to the build.
     */
    @JvmName("vomvmvhvtesgfjpt")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value Platform to be used to build and run the app.
     */
    @JvmName("bhmbeqtleohbojrm")
    public suspend fun platform(`value`: Output<String>) {
        this.platform = value
    }

    /**
     * @param value Platform version to be used to build and run the app.
     */
    @JvmName("fwarfiormkjuklqc")
    public suspend fun platformVersion(`value`: Output<String>) {
        this.platformVersion = value
    }

    /**
     * @param value List of steps to perform before the build.
     */
    @JvmName("flpcmkurlfxiwbox")
    public suspend fun preBuildSteps(`value`: Output<List<PreBuildStepArgs>>) {
        this.preBuildSteps = value
    }

    @JvmName("dwwpxvmwirdaxegq")
    public suspend fun preBuildSteps(vararg values: Output<PreBuildStepArgs>) {
        this.preBuildSteps = Output.all(values.asList())
    }

    /**
     * @param values List of steps to perform before the build.
     */
    @JvmName("txeohkabuhuhomlb")
    public suspend fun preBuildSteps(values: List<Output<PreBuildStepArgs>>) {
        this.preBuildSteps = Output.all(values)
    }

    /**
     * @param value Base OS used to build and run the app.
     */
    @JvmName("yuslpxxfuycebwil")
    public suspend fun baseOs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseOs = mapped
    }

    /**
     * @param value List of environment variables to be passed to the build.
     */
    @JvmName("odnisbpohyfnkryq")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables to be passed to the build.
     */
    @JvmName("lqufhxjkekohuloo")
    public suspend
    fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables to be passed to the build.
     */
    @JvmName("iyxijyjuqenukhic")
    public suspend fun environmentVariables(
        vararg
        argument: suspend EnvironmentVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument List of environment variables to be passed to the build.
     */
    @JvmName("jyottvtlpslxouwu")
    public suspend
    fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values List of environment variables to be passed to the build.
     */
    @JvmName("tpaimalohbjchidx")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Platform to be used to build and run the app.
     */
    @JvmName("lyeclbidjituoedl")
    public suspend fun platform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param value Platform version to be used to build and run the app.
     */
    @JvmName("ttpsrkcmlfokxoir")
    public suspend fun platformVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformVersion = mapped
    }

    /**
     * @param value List of steps to perform before the build.
     */
    @JvmName("anoxedhtlyesomai")
    public suspend fun preBuildSteps(`value`: List<PreBuildStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preBuildSteps = mapped
    }

    /**
     * @param argument List of steps to perform before the build.
     */
    @JvmName("hbrmlkgbscuuhetf")
    public suspend fun preBuildSteps(argument: List<suspend PreBuildStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PreBuildStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.preBuildSteps = mapped
    }

    /**
     * @param argument List of steps to perform before the build.
     */
    @JvmName("dsfnnbskespkmrix")
    public suspend fun preBuildSteps(vararg argument: suspend PreBuildStepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PreBuildStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.preBuildSteps = mapped
    }

    /**
     * @param argument List of steps to perform before the build.
     */
    @JvmName("fihesidsaretgtyi")
    public suspend fun preBuildSteps(argument: suspend PreBuildStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PreBuildStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.preBuildSteps = mapped
    }

    /**
     * @param values List of steps to perform before the build.
     */
    @JvmName("pvwdrvmnfykxjynu")
    public suspend fun preBuildSteps(vararg values: PreBuildStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preBuildSteps = mapped
    }

    internal fun build(): BuildConfigurationArgs = BuildConfigurationArgs(
        baseOs = baseOs,
        environmentVariables = environmentVariables,
        platform = platform,
        platformVersion = platformVersion,
        preBuildSteps = preBuildSteps,
    )
}
