@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpHeadersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HTTPHeader describes a custom header to be used in HTTP probes
 * @property name The header field name
 * @property value The header field value
 */
public data class ContainerAppProbeHttpHeadersArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpHeadersArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpHeadersArgs =
        com.pulumi.azurenative.app.inputs.ContainerAppProbeHttpHeadersArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerAppProbeHttpHeadersArgs].
 */
@PulumiTagMarker
public class ContainerAppProbeHttpHeadersArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The header field name
     */
    @JvmName("lmgvdcrvvwawrmvw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The header field value
     */
    @JvmName("ohlonaeoaajyqnmp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The header field name
     */
    @JvmName("ounnhxttokypsgcv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The header field value
     */
    @JvmName("hxlsdjhaxcxqbsht")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ContainerAppProbeHttpHeadersArgs = ContainerAppProbeHttpHeadersArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
