@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.CustomOpenIdConnectProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The configuration settings of the custom Open ID Connect provider.
 * @property enabled <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
 * @property login The configuration settings of the login flow of the custom Open ID Connect provider.
 * @property registration The configuration settings of the app registration for the custom Open ID Connect provider.
 */
public data class CustomOpenIdConnectProviderArgs(
    public val enabled: Output<Boolean>? = null,
    public val login: Output<OpenIdConnectLoginArgs>? = null,
    public val registration: Output<OpenIdConnectRegistrationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.CustomOpenIdConnectProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.CustomOpenIdConnectProviderArgs =
        com.pulumi.azurenative.app.inputs.CustomOpenIdConnectProviderArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .registration(registration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomOpenIdConnectProviderArgs].
 */
@PulumiTagMarker
public class CustomOpenIdConnectProviderArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var login: Output<OpenIdConnectLoginArgs>? = null

    private var registration: Output<OpenIdConnectRegistrationArgs>? = null

    /**
     * @param value <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
     */
    @JvmName("ioonxnxlrmknvxuu")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The configuration settings of the login flow of the custom Open ID Connect provider.
     */
    @JvmName("hhpfqjremdlcwnac")
    public suspend fun login(`value`: Output<OpenIdConnectLoginArgs>) {
        this.login = value
    }

    /**
     * @param value The configuration settings of the app registration for the custom Open ID Connect provider.
     */
    @JvmName("fusiyuvgfvcodtsu")
    public suspend fun registration(`value`: Output<OpenIdConnectRegistrationArgs>) {
        this.registration = value
    }

    /**
     * @param value <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
     */
    @JvmName("iskkknckjtbuedxu")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The configuration settings of the login flow of the custom Open ID Connect provider.
     */
    @JvmName("mmghrfylubvibikc")
    public suspend fun login(`value`: OpenIdConnectLoginArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param argument The configuration settings of the login flow of the custom Open ID Connect provider.
     */
    @JvmName("yjxtgraosmktulso")
    public suspend fun login(argument: suspend OpenIdConnectLoginArgsBuilder.() -> Unit) {
        val toBeMapped = OpenIdConnectLoginArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.login = mapped
    }

    /**
     * @param value The configuration settings of the app registration for the custom Open ID Connect provider.
     */
    @JvmName("modfubxplfnglifu")
    public suspend fun registration(`value`: OpenIdConnectRegistrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registration = mapped
    }

    /**
     * @param argument The configuration settings of the app registration for the custom Open ID Connect provider.
     */
    @JvmName("jkgdiirwbhlawwgi")
    public suspend
    fun registration(argument: suspend OpenIdConnectRegistrationArgsBuilder.() -> Unit) {
        val toBeMapped = OpenIdConnectRegistrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registration = mapped
    }

    internal fun build(): CustomOpenIdConnectProviderArgs = CustomOpenIdConnectProviderArgs(
        enabled = enabled,
        login = login,
        registration = registration,
    )
}
