@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.DefaultAuthorizationPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The configuration settings of the Azure Active Directory default authorization policy.
 * @property allowedApplications The configuration settings of the Azure Active Directory allowed applications.
 * @property allowedPrincipals The configuration settings of the Azure Active Directory allowed principals.
 */
public data class DefaultAuthorizationPolicyArgs(
    public val allowedApplications: Output<List<String>>? = null,
    public val allowedPrincipals: Output<AllowedPrincipalsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.DefaultAuthorizationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.DefaultAuthorizationPolicyArgs =
        com.pulumi.azurenative.app.inputs.DefaultAuthorizationPolicyArgs.builder()
            .allowedApplications(allowedApplications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedPrincipals(
                allowedPrincipals?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DefaultAuthorizationPolicyArgs].
 */
@PulumiTagMarker
public class DefaultAuthorizationPolicyArgsBuilder internal constructor() {
    private var allowedApplications: Output<List<String>>? = null

    private var allowedPrincipals: Output<AllowedPrincipalsArgs>? = null

    /**
     * @param value The configuration settings of the Azure Active Directory allowed applications.
     */
    @JvmName("oytiqneyjteablda")
    public suspend fun allowedApplications(`value`: Output<List<String>>) {
        this.allowedApplications = value
    }

    @JvmName("xtxqqkgjxoqljjmc")
    public suspend fun allowedApplications(vararg values: Output<String>) {
        this.allowedApplications = Output.all(values.asList())
    }

    /**
     * @param values The configuration settings of the Azure Active Directory allowed applications.
     */
    @JvmName("owtqotupmnaxyhid")
    public suspend fun allowedApplications(values: List<Output<String>>) {
        this.allowedApplications = Output.all(values)
    }

    /**
     * @param value The configuration settings of the Azure Active Directory allowed principals.
     */
    @JvmName("dqehtvpgghatokxr")
    public suspend fun allowedPrincipals(`value`: Output<AllowedPrincipalsArgs>) {
        this.allowedPrincipals = value
    }

    /**
     * @param value The configuration settings of the Azure Active Directory allowed applications.
     */
    @JvmName("hbqqeadavltladko")
    public suspend fun allowedApplications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedApplications = mapped
    }

    /**
     * @param values The configuration settings of the Azure Active Directory allowed applications.
     */
    @JvmName("tmhwfbdjjcawjfcm")
    public suspend fun allowedApplications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedApplications = mapped
    }

    /**
     * @param value The configuration settings of the Azure Active Directory allowed principals.
     */
    @JvmName("sflgrlckxwsupqgh")
    public suspend fun allowedPrincipals(`value`: AllowedPrincipalsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedPrincipals = mapped
    }

    /**
     * @param argument The configuration settings of the Azure Active Directory allowed principals.
     */
    @JvmName("pkdmdwnrucsbjutd")
    public suspend fun allowedPrincipals(argument: suspend AllowedPrincipalsArgsBuilder.() -> Unit) {
        val toBeMapped = AllowedPrincipalsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.allowedPrincipals = mapped
    }

    internal fun build(): DefaultAuthorizationPolicyArgs = DefaultAuthorizationPolicyArgs(
        allowedApplications = allowedApplications,
        allowedPrincipals = allowedPrincipals,
    )
}
