@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.EnvironmentSkuPropertiesArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.SkuName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed Environment resource SKU properties.
 * @property name Name of the Sku.
 */
public data class EnvironmentSkuPropertiesArgs(
    public val name: Output<Either<String, SkuName>>,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.EnvironmentSkuPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.EnvironmentSkuPropertiesArgs =
        com.pulumi.azurenative.app.inputs.EnvironmentSkuPropertiesArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EnvironmentSkuPropertiesArgs].
 */
@PulumiTagMarker
public class EnvironmentSkuPropertiesArgsBuilder internal constructor() {
    private var name: Output<Either<String, SkuName>>? = null

    /**
     * @param value Name of the Sku.
     */
    @JvmName("pjfeyyxxbsjnngfp")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("kriepryhschndeis")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("hbguvbwnypxxprqu")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the Sku.
     */
    @JvmName("rarcmycmscbqaslu")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): EnvironmentSkuPropertiesArgs = EnvironmentSkuPropertiesArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
