@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetBuilderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property builderName The name of the builder.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBuilderPlainArgs(
    public val builderName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetBuilderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetBuilderPlainArgs =
        com.pulumi.azurenative.app.inputs.GetBuilderPlainArgs.builder()
            .builderName(builderName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBuilderPlainArgs].
 */
@PulumiTagMarker
public class GetBuilderPlainArgsBuilder internal constructor() {
    private var builderName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the builder.
     */
    @JvmName("ohbmqqurarnglwuu")
    public suspend fun builderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.builderName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qlatxdjnwcjwciwe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBuilderPlainArgs = GetBuilderPlainArgs(
        builderName = builderName ?: throw PulumiNullFieldException("builderName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
