@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsStoragePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectedEnvironmentName Name of the Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageName Name of the storage.
 */
public data class GetConnectedEnvironmentsStoragePlainArgs(
    public val connectedEnvironmentName: String,
    public val resourceGroupName: String,
    public val storageName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsStoragePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsStoragePlainArgs =
        com.pulumi.azurenative.app.inputs.GetConnectedEnvironmentsStoragePlainArgs.builder()
            .connectedEnvironmentName(connectedEnvironmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageName(storageName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectedEnvironmentsStoragePlainArgs].
 */
@PulumiTagMarker
public class GetConnectedEnvironmentsStoragePlainArgsBuilder internal constructor() {
    private var connectedEnvironmentName: String? = null

    private var resourceGroupName: String? = null

    private var storageName: String? = null

    /**
     * @param value Name of the Environment.
     */
    @JvmName("ttbrdirndcojqviq")
    public suspend fun connectedEnvironmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectedEnvironmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gjuxkbybtesbenel")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the storage.
     */
    @JvmName("opoqqdicsnrvqjce")
    public suspend fun storageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageName = mapped
    }

    internal fun build(): GetConnectedEnvironmentsStoragePlainArgs =
        GetConnectedEnvironmentsStoragePlainArgs(
            connectedEnvironmentName = connectedEnvironmentName ?: throw
                PulumiNullFieldException("connectedEnvironmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            storageName = storageName ?: throw PulumiNullFieldException("storageName"),
        )
}
