@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GetManagedEnvironmentAuthTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentName Name of the Managed Environment.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetManagedEnvironmentAuthTokenPlainArgs(
    public val environmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GetManagedEnvironmentAuthTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GetManagedEnvironmentAuthTokenPlainArgs =
        com.pulumi.azurenative.app.inputs.GetManagedEnvironmentAuthTokenPlainArgs.builder()
            .environmentName(environmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedEnvironmentAuthTokenPlainArgs].
 */
@PulumiTagMarker
public class GetManagedEnvironmentAuthTokenPlainArgsBuilder internal constructor() {
    private var environmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Managed Environment.
     */
    @JvmName("qeolnmeljgufbafy")
    public suspend fun environmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rkrjgnbbglqmutka")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedEnvironmentAuthTokenPlainArgs =
        GetManagedEnvironmentAuthTokenPlainArgs(
            environmentName = environmentName ?: throw PulumiNullFieldException("environmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
