@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.GithubActionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration properties that define the mutable settings of a Container App SourceControl
 * @property azureCredentials AzureCredentials configurations.
 * @property contextPath Context path
 * @property image Image name
 * @property os Operation system
 * @property publishType Code or Image
 * @property registryInfo Registry configurations.
 * @property runtimeStack Runtime stack
 * @property runtimeVersion Runtime version
 */
public data class GithubActionConfigurationArgs(
    public val azureCredentials: Output<AzureCredentialsArgs>? = null,
    public val contextPath: Output<String>? = null,
    public val image: Output<String>? = null,
    public val os: Output<String>? = null,
    public val publishType: Output<String>? = null,
    public val registryInfo: Output<RegistryInfoArgs>? = null,
    public val runtimeStack: Output<String>? = null,
    public val runtimeVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.GithubActionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.GithubActionConfigurationArgs =
        com.pulumi.azurenative.app.inputs.GithubActionConfigurationArgs.builder()
            .azureCredentials(azureCredentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contextPath(contextPath?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .os(os?.applyValue({ args0 -> args0 }))
            .publishType(publishType?.applyValue({ args0 -> args0 }))
            .registryInfo(registryInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .runtimeStack(runtimeStack?.applyValue({ args0 -> args0 }))
            .runtimeVersion(runtimeVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GithubActionConfigurationArgs].
 */
@PulumiTagMarker
public class GithubActionConfigurationArgsBuilder internal constructor() {
    private var azureCredentials: Output<AzureCredentialsArgs>? = null

    private var contextPath: Output<String>? = null

    private var image: Output<String>? = null

    private var os: Output<String>? = null

    private var publishType: Output<String>? = null

    private var registryInfo: Output<RegistryInfoArgs>? = null

    private var runtimeStack: Output<String>? = null

    private var runtimeVersion: Output<String>? = null

    /**
     * @param value AzureCredentials configurations.
     */
    @JvmName("ijjdnoaqeyogsgsh")
    public suspend fun azureCredentials(`value`: Output<AzureCredentialsArgs>) {
        this.azureCredentials = value
    }

    /**
     * @param value Context path
     */
    @JvmName("dwjkyoqqykwihjrg")
    public suspend fun contextPath(`value`: Output<String>) {
        this.contextPath = value
    }

    /**
     * @param value Image name
     */
    @JvmName("wmbdsapxwskjsytt")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Operation system
     */
    @JvmName("vnjmvaycoadghqoe")
    public suspend fun os(`value`: Output<String>) {
        this.os = value
    }

    /**
     * @param value Code or Image
     */
    @JvmName("remmqyvlpsdbodoa")
    public suspend fun publishType(`value`: Output<String>) {
        this.publishType = value
    }

    /**
     * @param value Registry configurations.
     */
    @JvmName("tnheshtjhuenxoxi")
    public suspend fun registryInfo(`value`: Output<RegistryInfoArgs>) {
        this.registryInfo = value
    }

    /**
     * @param value Runtime stack
     */
    @JvmName("sobertdwjbgcpxhv")
    public suspend fun runtimeStack(`value`: Output<String>) {
        this.runtimeStack = value
    }

    /**
     * @param value Runtime version
     */
    @JvmName("iaareonwsjkranyl")
    public suspend fun runtimeVersion(`value`: Output<String>) {
        this.runtimeVersion = value
    }

    /**
     * @param value AzureCredentials configurations.
     */
    @JvmName("vgqgyocdcfablwjg")
    public suspend fun azureCredentials(`value`: AzureCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCredentials = mapped
    }

    /**
     * @param argument AzureCredentials configurations.
     */
    @JvmName("qvhdasunkrbnpqrw")
    public suspend fun azureCredentials(argument: suspend AzureCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AzureCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureCredentials = mapped
    }

    /**
     * @param value Context path
     */
    @JvmName("peapxowouliktste")
    public suspend fun contextPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextPath = mapped
    }

    /**
     * @param value Image name
     */
    @JvmName("kbmfqpueqeplfnhq")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Operation system
     */
    @JvmName("eqyggflcetcnwoqn")
    public suspend fun os(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value Code or Image
     */
    @JvmName("glkwultiyhqclner")
    public suspend fun publishType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishType = mapped
    }

    /**
     * @param value Registry configurations.
     */
    @JvmName("hxthbaumbbvmenrt")
    public suspend fun registryInfo(`value`: RegistryInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryInfo = mapped
    }

    /**
     * @param argument Registry configurations.
     */
    @JvmName("iescvgncmakwlslk")
    public suspend fun registryInfo(argument: suspend RegistryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = RegistryInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.registryInfo = mapped
    }

    /**
     * @param value Runtime stack
     */
    @JvmName("esachgfvvipmahgy")
    public suspend fun runtimeStack(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeStack = mapped
    }

    /**
     * @param value Runtime version
     */
    @JvmName("bbgdyqenfypstdes")
    public suspend fun runtimeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeVersion = mapped
    }

    internal fun build(): GithubActionConfigurationArgs = GithubActionConfigurationArgs(
        azureCredentials = azureCredentials,
        contextPath = contextPath,
        image = image,
        os = os,
        publishType = publishType,
        registryInfo = registryInfo,
        runtimeStack = runtimeStack,
        runtimeVersion = runtimeVersion,
    )
}
