@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.InitContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container App init container definition
 * @property args Container start command arguments.
 * @property command Container start command.
 * @property env Container environment variables.
 * @property image Container image tag.
 * @property name Custom container name.
 * @property resources Container resource requirements.
 * @property volumeMounts Container volume mounts.
 */
public data class InitContainerArgs(
    public val args: Output<List<String>>? = null,
    public val command: Output<List<String>>? = null,
    public val env: Output<List<EnvironmentVarArgs>>? = null,
    public val image: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resources: Output<ContainerResourcesArgs>? = null,
    public val volumeMounts: Output<List<VolumeMountArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.InitContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.InitContainerArgs =
        com.pulumi.azurenative.app.inputs.InitContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .env(env?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .image(image?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InitContainerArgs].
 */
@PulumiTagMarker
public class InitContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var command: Output<List<String>>? = null

    private var env: Output<List<EnvironmentVarArgs>>? = null

    private var image: Output<String>? = null

    private var name: Output<String>? = null

    private var resources: Output<ContainerResourcesArgs>? = null

    private var volumeMounts: Output<List<VolumeMountArgs>>? = null

    /**
     * @param value Container start command arguments.
     */
    @JvmName("uhvgcuotgbumthqb")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("mrunyoaaiuboxrhg")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("upthgkbgxsftvhkq")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Container start command.
     */
    @JvmName("amqrwapwflkdrjar")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("puorvhiboswgvnsl")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values Container start command.
     */
    @JvmName("hanhcirjfminrgap")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("ofawsdbvrxgkjlbb")
    public suspend fun env(`value`: Output<List<EnvironmentVarArgs>>) {
        this.env = value
    }

    @JvmName("bpkydoytnrjugvdq")
    public suspend fun env(vararg values: Output<EnvironmentVarArgs>) {
        this.env = Output.all(values.asList())
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("kmberhsgxhpbacda")
    public suspend fun env(values: List<Output<EnvironmentVarArgs>>) {
        this.env = Output.all(values)
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("svfcjdgxrgheifmt")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("ivkqktictmudjrai")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("vorwrwqlxxvooanj")
    public suspend fun resources(`value`: Output<ContainerResourcesArgs>) {
        this.resources = value
    }

    /**
     * @param value Container volume mounts.
     */
    @JvmName("grmvcostiuukokal")
    public suspend fun volumeMounts(`value`: Output<List<VolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("nusckgeoxsgkcinp")
    public suspend fun volumeMounts(vararg values: Output<VolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values Container volume mounts.
     */
    @JvmName("aaeschxyrauamccc")
    public suspend fun volumeMounts(values: List<Output<VolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value Container start command arguments.
     */
    @JvmName("dpxmhihpibmtlaxu")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Container start command arguments.
     */
    @JvmName("kmcwqeojnfarmjog")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Container start command.
     */
    @JvmName("juddgiuinshrydgn")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values Container start command.
     */
    @JvmName("hwmpqpkslpdajiru")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Container environment variables.
     */
    @JvmName("bcqambfdcqbycbvc")
    public suspend fun env(`value`: List<EnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("xbjjaauuyfkdwxdj")
    public suspend fun env(argument: List<suspend EnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("iolkpjfhvmxwflxl")
    public suspend fun env(vararg argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVarArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param argument Container environment variables.
     */
    @JvmName("yakvsdaxjqgbkfgq")
    public suspend fun env(argument: suspend EnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVarArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.env = mapped
    }

    /**
     * @param values Container environment variables.
     */
    @JvmName("viwyrikwaospduxf")
    public suspend fun env(vararg values: EnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.env = mapped
    }

    /**
     * @param value Container image tag.
     */
    @JvmName("xfhixvxuhacdllkn")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Custom container name.
     */
    @JvmName("oyxpsfceojxmacrf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Container resource requirements.
     */
    @JvmName("afpndlcypqspotbq")
    public suspend fun resources(`value`: ContainerResourcesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Container resource requirements.
     */
    @JvmName("yakueupclunyulcb")
    public suspend fun resources(argument: suspend ContainerResourcesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerResourcesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value Container volume mounts.
     */
    @JvmName("dypjykhqnekmrvyk")
    public suspend fun volumeMounts(`value`: List<VolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("onhlftuasrkbkhrt")
    public suspend fun volumeMounts(argument: List<suspend VolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("qvnlgxrgoyhmunlo")
    public suspend fun volumeMounts(vararg argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeMountArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument Container volume mounts.
     */
    @JvmName("ehlmhlapdxyeufuw")
    public suspend fun volumeMounts(argument: suspend VolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeMountArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values Container volume mounts.
     */
    @JvmName("byiktrcarlavsjlw")
    public suspend fun volumeMounts(vararg values: VolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    internal fun build(): InitContainerArgs = InitContainerArgs(
        args = args,
        command = command,
        env = env,
        image = image,
        name = name,
        resources = resources,
        volumeMounts = volumeMounts,
    )
}
