@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobConfigurationEventTriggerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Trigger configuration of an event driven job.
 * @property parallelism Number of parallel replicas of a job that can run at a given time.
 * @property replicaCompletionCount Minimum number of successful replica completions before overall job completion.
 * @property scale Scaling configurations for event driven jobs.
 */
public data class JobConfigurationEventTriggerConfigArgs(
    public val parallelism: Output<Int>? = null,
    public val replicaCompletionCount: Output<Int>? = null,
    public val scale: Output<JobScaleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobConfigurationEventTriggerConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobConfigurationEventTriggerConfigArgs =
        com.pulumi.azurenative.app.inputs.JobConfigurationEventTriggerConfigArgs.builder()
            .parallelism(parallelism?.applyValue({ args0 -> args0 }))
            .replicaCompletionCount(replicaCompletionCount?.applyValue({ args0 -> args0 }))
            .scale(scale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [JobConfigurationEventTriggerConfigArgs].
 */
@PulumiTagMarker
public class JobConfigurationEventTriggerConfigArgsBuilder internal constructor() {
    private var parallelism: Output<Int>? = null

    private var replicaCompletionCount: Output<Int>? = null

    private var scale: Output<JobScaleArgs>? = null

    /**
     * @param value Number of parallel replicas of a job that can run at a given time.
     */
    @JvmName("wtvmptyqettdiqug")
    public suspend fun parallelism(`value`: Output<Int>) {
        this.parallelism = value
    }

    /**
     * @param value Minimum number of successful replica completions before overall job completion.
     */
    @JvmName("ybxgwmbvbcswjlty")
    public suspend fun replicaCompletionCount(`value`: Output<Int>) {
        this.replicaCompletionCount = value
    }

    /**
     * @param value Scaling configurations for event driven jobs.
     */
    @JvmName("bvtanjsjfsoudrsi")
    public suspend fun scale(`value`: Output<JobScaleArgs>) {
        this.scale = value
    }

    /**
     * @param value Number of parallel replicas of a job that can run at a given time.
     */
    @JvmName("sawchmtqrycujvkv")
    public suspend fun parallelism(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelism = mapped
    }

    /**
     * @param value Minimum number of successful replica completions before overall job completion.
     */
    @JvmName("imvipvygfjlersse")
    public suspend fun replicaCompletionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCompletionCount = mapped
    }

    /**
     * @param value Scaling configurations for event driven jobs.
     */
    @JvmName("qykqgyhkullamwix")
    public suspend fun scale(`value`: JobScaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param argument Scaling configurations for event driven jobs.
     */
    @JvmName("xxawerbbrmbawqng")
    public suspend fun scale(argument: suspend JobScaleArgsBuilder.() -> Unit) {
        val toBeMapped = JobScaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scale = mapped
    }

    internal fun build(): JobConfigurationEventTriggerConfigArgs =
        JobConfigurationEventTriggerConfigArgs(
            parallelism = parallelism,
            replicaCompletionCount = replicaCompletionCount,
            scale = scale,
        )
}
