@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobScaleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Scaling rule.
 * @property auth Authentication secrets for the scale rule.
 * @property metadata Metadata properties to describe the scale rule.
 * @property name Scale Rule Name
 * @property type Type of the scale rule
 * eg: azure-servicebus, redis etc.
 */
public data class JobScaleRuleArgs(
    public val auth: Output<List<ScaleRuleAuthArgs>>? = null,
    public val metadata: Output<Any>? = null,
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobScaleRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobScaleRuleArgs =
        com.pulumi.azurenative.app.inputs.JobScaleRuleArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobScaleRuleArgs].
 */
@PulumiTagMarker
public class JobScaleRuleArgsBuilder internal constructor() {
    private var auth: Output<List<ScaleRuleAuthArgs>>? = null

    private var metadata: Output<Any>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Authentication secrets for the scale rule.
     */
    @JvmName("rhqukpkbeuprkqpk")
    public suspend fun auth(`value`: Output<List<ScaleRuleAuthArgs>>) {
        this.auth = value
    }

    @JvmName("mmyhifvmlvnntxnv")
    public suspend fun auth(vararg values: Output<ScaleRuleAuthArgs>) {
        this.auth = Output.all(values.asList())
    }

    /**
     * @param values Authentication secrets for the scale rule.
     */
    @JvmName("drhknseeilonfyhd")
    public suspend fun auth(values: List<Output<ScaleRuleAuthArgs>>) {
        this.auth = Output.all(values)
    }

    /**
     * @param value Metadata properties to describe the scale rule.
     */
    @JvmName("cavcdnvjhtqsgkuf")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value Scale Rule Name
     */
    @JvmName("wkmjgwmrwxdcbiji")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of the scale rule
     * eg: azure-servicebus, redis etc.
     */
    @JvmName("xrtilcwcnlltydrt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Authentication secrets for the scale rule.
     */
    @JvmName("hvthkwnponoakjtw")
    public suspend fun auth(`value`: List<ScaleRuleAuthArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the scale rule.
     */
    @JvmName("qeofhndjtbimkdvd")
    public suspend fun auth(argument: List<suspend ScaleRuleAuthArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the scale rule.
     */
    @JvmName("xboqoiwwroqwdado")
    public suspend fun auth(vararg argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScaleRuleAuthArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param argument Authentication secrets for the scale rule.
     */
    @JvmName("ehoowgychtsrfnrv")
    public suspend fun auth(argument: suspend ScaleRuleAuthArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleRuleAuthArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param values Authentication secrets for the scale rule.
     */
    @JvmName("hubdmcllerobmpqg")
    public suspend fun auth(vararg values: ScaleRuleAuthArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param value Metadata properties to describe the scale rule.
     */
    @JvmName("hvxywdotvskownrk")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Scale Rule Name
     */
    @JvmName("ixajxqqneujyqbck")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of the scale rule
     * eg: azure-servicebus, redis etc.
     */
    @JvmName("jtcdekigbolotxuc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JobScaleRuleArgs = JobScaleRuleArgs(
        auth = auth,
        metadata = metadata,
        name = name,
        type = type,
    )
}
