@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.JobTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container Apps Job versioned application definition. Defines the desired state of an immutable revision. Any changes to this section Will result in a new revision being created
 * @property containers List of container definitions for the Container App.
 * @property initContainers List of specialized containers that run before app containers.
 * @property volumes List of volume definitions for the Container App.
 */
public data class JobTemplateArgs(
    public val containers: Output<List<ContainerArgs>>? = null,
    public val initContainers: Output<List<InitContainerArgs>>? = null,
    public val volumes: Output<List<VolumeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.JobTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.JobTemplateArgs =
        com.pulumi.azurenative.app.inputs.JobTemplateArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .initContainers(
                initContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobTemplateArgs].
 */
@PulumiTagMarker
public class JobTemplateArgsBuilder internal constructor() {
    private var containers: Output<List<ContainerArgs>>? = null

    private var initContainers: Output<List<InitContainerArgs>>? = null

    private var volumes: Output<List<VolumeArgs>>? = null

    /**
     * @param value List of container definitions for the Container App.
     */
    @JvmName("tiwniersnhlkycks")
    public suspend fun containers(`value`: Output<List<ContainerArgs>>) {
        this.containers = value
    }

    @JvmName("mlknwxmxhnueyqlv")
    public suspend fun containers(vararg values: Output<ContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values List of container definitions for the Container App.
     */
    @JvmName("ptvanhgnksrkwbnn")
    public suspend fun containers(values: List<Output<ContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value List of specialized containers that run before app containers.
     */
    @JvmName("vjwrjwyqdmoaxrid")
    public suspend fun initContainers(`value`: Output<List<InitContainerArgs>>) {
        this.initContainers = value
    }

    @JvmName("jpmrcgvtqycqlwlv")
    public suspend fun initContainers(vararg values: Output<InitContainerArgs>) {
        this.initContainers = Output.all(values.asList())
    }

    /**
     * @param values List of specialized containers that run before app containers.
     */
    @JvmName("taocbnbqibsoxsxd")
    public suspend fun initContainers(values: List<Output<InitContainerArgs>>) {
        this.initContainers = Output.all(values)
    }

    /**
     * @param value List of volume definitions for the Container App.
     */
    @JvmName("ipvofyvlpvmeirjv")
    public suspend fun volumes(`value`: Output<List<VolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("vwtbebmoupoyodyh")
    public suspend fun volumes(vararg values: Output<VolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values List of volume definitions for the Container App.
     */
    @JvmName("brafxchaixybuvdp")
    public suspend fun volumes(values: List<Output<VolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value List of container definitions for the Container App.
     */
    @JvmName("qorenpldhsrbofya")
    public suspend fun containers(`value`: List<ContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("soumppxwehwapjaa")
    public suspend fun containers(argument: List<suspend ContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("swkasxnfexjbaokh")
    public suspend fun containers(vararg argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument List of container definitions for the Container App.
     */
    @JvmName("jgkokkjbjldffbyj")
    public suspend fun containers(argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values List of container definitions for the Container App.
     */
    @JvmName("ksmlnktjfhqlonlb")
    public suspend fun containers(vararg values: ContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value List of specialized containers that run before app containers.
     */
    @JvmName("wqiawjmlggcyfygq")
    public suspend fun initContainers(`value`: List<InitContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param argument List of specialized containers that run before app containers.
     */
    @JvmName("apuinxthvuclfjgu")
    public suspend fun initContainers(argument: List<suspend InitContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InitContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument List of specialized containers that run before app containers.
     */
    @JvmName("xdrudanlduljrxaj")
    public suspend fun initContainers(vararg argument: suspend InitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InitContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument List of specialized containers that run before app containers.
     */
    @JvmName("ednfkejvklrjthtf")
    public suspend fun initContainers(argument: suspend InitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InitContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param values List of specialized containers that run before app containers.
     */
    @JvmName("rowjmliuposiddho")
    public suspend fun initContainers(vararg values: InitContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param value List of volume definitions for the Container App.
     */
    @JvmName("fdcbsbmfhcxdnkva")
    public suspend fun volumes(`value`: List<VolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument List of volume definitions for the Container App.
     */
    @JvmName("kiaqnxlpatkjbtwu")
    public suspend fun volumes(argument: List<suspend VolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument List of volume definitions for the Container App.
     */
    @JvmName("exdtqbabxaagorti")
    public suspend fun volumes(vararg argument: suspend VolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument List of volume definitions for the Container App.
     */
    @JvmName("gqooyifenmryyykw")
    public suspend fun volumes(argument: suspend VolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values List of volume definitions for the Container App.
     */
    @JvmName("fdssyakvjgaaoiwk")
    public suspend fun volumes(vararg values: VolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): JobTemplateArgs = JobTemplateArgs(
        containers = containers,
        initContainers = initContainers,
        volumes = volumes,
    )
}
