@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ListContainerAppCustomHostNameAnalysisPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property containerAppName Name of the Container App.
 * @property customHostname Custom hostname.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListContainerAppCustomHostNameAnalysisPlainArgs(
    public val containerAppName: String,
    public val customHostname: String? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.app.inputs.ListContainerAppCustomHostNameAnalysisPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.app.inputs.ListContainerAppCustomHostNameAnalysisPlainArgs =
        com.pulumi.azurenative.app.inputs.ListContainerAppCustomHostNameAnalysisPlainArgs.builder()
            .containerAppName(containerAppName.let({ args0 -> args0 }))
            .customHostname(customHostname?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListContainerAppCustomHostNameAnalysisPlainArgs].
 */
@PulumiTagMarker
public class ListContainerAppCustomHostNameAnalysisPlainArgsBuilder internal constructor() {
    private var containerAppName: String? = null

    private var customHostname: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Container App.
     */
    @JvmName("mvaigctkgkqgkfxk")
    public suspend fun containerAppName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerAppName = mapped
    }

    /**
     * @param value Custom hostname.
     */
    @JvmName("gfnlavyxtkyukbuk")
    public suspend fun customHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customHostname = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xcuirrgrwktrxiwg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListContainerAppCustomHostNameAnalysisPlainArgs =
        ListContainerAppCustomHostNameAnalysisPlainArgs(
            containerAppName = containerAppName ?: throw PulumiNullFieldException("containerAppName"),
            customHostname = customHostname,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
