@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.LogAnalyticsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log Analytics configuration, must only be provided when destination is configured as 'log-analytics'
 * @property customerId Log analytics customer id
 * @property sharedKey Log analytics customer key
 */
public data class LogAnalyticsConfigurationArgs(
    public val customerId: Output<String>? = null,
    public val sharedKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.LogAnalyticsConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.LogAnalyticsConfigurationArgs =
        com.pulumi.azurenative.app.inputs.LogAnalyticsConfigurationArgs.builder()
            .customerId(customerId?.applyValue({ args0 -> args0 }))
            .sharedKey(sharedKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogAnalyticsConfigurationArgs].
 */
@PulumiTagMarker
public class LogAnalyticsConfigurationArgsBuilder internal constructor() {
    private var customerId: Output<String>? = null

    private var sharedKey: Output<String>? = null

    /**
     * @param value Log analytics customer id
     */
    @JvmName("ngxlsugunqstmcjg")
    public suspend fun customerId(`value`: Output<String>) {
        this.customerId = value
    }

    /**
     * @param value Log analytics customer key
     */
    @JvmName("pdnrhlgowdlwypah")
    public suspend fun sharedKey(`value`: Output<String>) {
        this.sharedKey = value
    }

    /**
     * @param value Log analytics customer id
     */
    @JvmName("krwolkawhojwghtt")
    public suspend fun customerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerId = mapped
    }

    /**
     * @param value Log analytics customer key
     */
    @JvmName("illtpwjianvyrary")
    public suspend fun sharedKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedKey = mapped
    }

    internal fun build(): LogAnalyticsConfigurationArgs = LogAnalyticsConfigurationArgs(
        customerId = customerId,
        sharedKey = sharedKey,
    )
}
