@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.ManagedEnvironmentOutboundSettingsArgs.builder
import com.pulumi.azurenative.app.kotlin.enums.ManagedEnvironmentOutBoundType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration used to control the Environment Egress outbound traffic
 * @property outBoundType Outbound type for the cluster
 * @property virtualNetworkApplianceIp Virtual Appliance IP used as the Egress controller for the Environment
 */
public data class ManagedEnvironmentOutboundSettingsArgs(
    public val outBoundType: Output<Either<String, ManagedEnvironmentOutBoundType>>? = null,
    public val virtualNetworkApplianceIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.ManagedEnvironmentOutboundSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.ManagedEnvironmentOutboundSettingsArgs =
        com.pulumi.azurenative.app.inputs.ManagedEnvironmentOutboundSettingsArgs.builder()
            .outBoundType(
                outBoundType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualNetworkApplianceIp(virtualNetworkApplianceIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedEnvironmentOutboundSettingsArgs].
 */
@PulumiTagMarker
public class ManagedEnvironmentOutboundSettingsArgsBuilder internal constructor() {
    private var outBoundType: Output<Either<String, ManagedEnvironmentOutBoundType>>? = null

    private var virtualNetworkApplianceIp: Output<String>? = null

    /**
     * @param value Outbound type for the cluster
     */
    @JvmName("ebkoqvbhqeombner")
    public suspend fun outBoundType(`value`: Output<Either<String, ManagedEnvironmentOutBoundType>>) {
        this.outBoundType = value
    }

    /**
     * @param value Virtual Appliance IP used as the Egress controller for the Environment
     */
    @JvmName("ckmfcrxbeumflrgv")
    public suspend fun virtualNetworkApplianceIp(`value`: Output<String>) {
        this.virtualNetworkApplianceIp = value
    }

    /**
     * @param value Outbound type for the cluster
     */
    @JvmName("gidyesonagjltyty")
    public suspend fun outBoundType(`value`: Either<String, ManagedEnvironmentOutBoundType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outBoundType = mapped
    }

    /**
     * @param value Outbound type for the cluster
     */
    @JvmName("kkehuowbpkyupplb")
    public fun outBoundType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedEnvironmentOutBoundType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outBoundType = mapped
    }

    /**
     * @param value Outbound type for the cluster
     */
    @JvmName("ishianebfpcpeiok")
    public fun outBoundType(`value`: ManagedEnvironmentOutBoundType) {
        val toBeMapped = Either.ofRight<String, ManagedEnvironmentOutBoundType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outBoundType = mapped
    }

    /**
     * @param value Virtual Appliance IP used as the Egress controller for the Environment
     */
    @JvmName("cwqthxqpbokgxdff")
    public suspend fun virtualNetworkApplianceIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkApplianceIp = mapped
    }

    internal fun build(): ManagedEnvironmentOutboundSettingsArgs =
        ManagedEnvironmentOutboundSettingsArgs(
            outBoundType = outBoundType,
            virtualNetworkApplianceIp = virtualNetworkApplianceIp,
        )
}
