@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.PreBuildStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model representing a pre-build step.
 * @property description Description of the pre-build step.
 * @property httpGet Http get request to send before the build.
 * @property scripts List of custom commands to run.
 */
public data class PreBuildStepArgs(
    public val description: Output<String>? = null,
    public val httpGet: Output<HttpGetArgs>? = null,
    public val scripts: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.PreBuildStepArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.PreBuildStepArgs =
        com.pulumi.azurenative.app.inputs.PreBuildStepArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .httpGet(httpGet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scripts(scripts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PreBuildStepArgs].
 */
@PulumiTagMarker
public class PreBuildStepArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var httpGet: Output<HttpGetArgs>? = null

    private var scripts: Output<List<String>>? = null

    /**
     * @param value Description of the pre-build step.
     */
    @JvmName("wrjqqcuxmgcgutug")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Http get request to send before the build.
     */
    @JvmName("dwswvsmcbaistaft")
    public suspend fun httpGet(`value`: Output<HttpGetArgs>) {
        this.httpGet = value
    }

    /**
     * @param value List of custom commands to run.
     */
    @JvmName("qeaijrbyqisugeue")
    public suspend fun scripts(`value`: Output<List<String>>) {
        this.scripts = value
    }

    @JvmName("aeinbfvffcuhffsb")
    public suspend fun scripts(vararg values: Output<String>) {
        this.scripts = Output.all(values.asList())
    }

    /**
     * @param values List of custom commands to run.
     */
    @JvmName("rdvombultylltgmd")
    public suspend fun scripts(values: List<Output<String>>) {
        this.scripts = Output.all(values)
    }

    /**
     * @param value Description of the pre-build step.
     */
    @JvmName("mnrlvuiltwpybcsi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Http get request to send before the build.
     */
    @JvmName("howpugaobnpdjwvx")
    public suspend fun httpGet(`value`: HttpGetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGet = mapped
    }

    /**
     * @param argument Http get request to send before the build.
     */
    @JvmName("lbberlaoawsrfqmu")
    public suspend fun httpGet(argument: suspend HttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = HttpGetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpGet = mapped
    }

    /**
     * @param value List of custom commands to run.
     */
    @JvmName("jmrhdladqdwmfrwm")
    public suspend fun scripts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scripts = mapped
    }

    /**
     * @param values List of custom commands to run.
     */
    @JvmName("fayhfaoltegvjxms")
    public suspend fun scripts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scripts = mapped
    }

    internal fun build(): PreBuildStepArgs = PreBuildStepArgs(
        description = description,
        httpGet = httpGet,
        scripts = scripts,
    )
}
