@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.TcpConnectionPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines parameters for tcp connection pooling
 * @property maxConnections Maximum number of tcp connections allowed
 */
public data class TcpConnectionPoolArgs(
    public val maxConnections: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.TcpConnectionPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.TcpConnectionPoolArgs =
        com.pulumi.azurenative.app.inputs.TcpConnectionPoolArgs.builder()
            .maxConnections(maxConnections?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TcpConnectionPoolArgs].
 */
@PulumiTagMarker
public class TcpConnectionPoolArgsBuilder internal constructor() {
    private var maxConnections: Output<Int>? = null

    /**
     * @param value Maximum number of tcp connections allowed
     */
    @JvmName("aiokjrbhdvdboeba")
    public suspend fun maxConnections(`value`: Output<Int>) {
        this.maxConnections = value
    }

    /**
     * @param value Maximum number of tcp connections allowed
     */
    @JvmName("qlwugabppqiklekv")
    public suspend fun maxConnections(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConnections = mapped
    }

    internal fun build(): TcpConnectionPoolArgs = TcpConnectionPoolArgs(
        maxConnections = maxConnections,
    )
}
