@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.inputs

import com.pulumi.azurenative.app.inputs.VolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Volume mount for the Container App.
 * @property mountPath Path within the container at which the volume should be mounted.Must not contain ':'.
 * @property subPath Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
 * @property volumeName This must match the Name of a Volume.
 */
public data class VolumeMountArgs(
    public val mountPath: Output<String>? = null,
    public val subPath: Output<String>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.app.inputs.VolumeMountArgs> {
    override fun toJava(): com.pulumi.azurenative.app.inputs.VolumeMountArgs =
        com.pulumi.azurenative.app.inputs.VolumeMountArgs.builder()
            .mountPath(mountPath?.applyValue({ args0 -> args0 }))
            .subPath(subPath?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeMountArgs].
 */
@PulumiTagMarker
public class VolumeMountArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var subPath: Output<String>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value Path within the container at which the volume should be mounted.Must not contain ':'.
     */
    @JvmName("vacsapotyuqrqdri")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
     */
    @JvmName("wwkgllosgljkkmoj")
    public suspend fun subPath(`value`: Output<String>) {
        this.subPath = value
    }

    /**
     * @param value This must match the Name of a Volume.
     */
    @JvmName("kspowqwhwxwcpcbj")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value Path within the container at which the volume should be mounted.Must not contain ':'.
     */
    @JvmName("ahehhwuglwkeavdj")
    public suspend fun mountPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
     */
    @JvmName("wmxasmmorxagvxoj")
    public suspend fun subPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subPath = mapped
    }

    /**
     * @param value This must match the Name of a Volume.
     */
    @JvmName("ilyysiwnrlrrhqqr")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): VolumeMountArgs = VolumeMountArgs(
        mountPath = mountPath,
        subPath = subPath,
        volumeName = volumeName,
    )
}
