@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration of the build.
 * @property baseOs Base OS used to build and run the app.
 * @property environmentVariables List of environment variables to be passed to the build.
 * @property platform Platform to be used to build and run the app.
 * @property platformVersion Platform version to be used to build and run the app.
 * @property preBuildSteps List of steps to perform before the build.
 */
public data class BuildConfigurationResponse(
    public val baseOs: String? = null,
    public val environmentVariables: List<EnvironmentVariableResponse>? = null,
    public val platform: String? = null,
    public val platformVersion: String? = null,
    public val preBuildSteps: List<PreBuildStepResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.BuildConfigurationResponse):
            BuildConfigurationResponse = BuildConfigurationResponse(
            baseOs = javaType.baseOs().map({ args0 -> args0 }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                })
            }),
            platform = javaType.platform().map({ args0 -> args0 }).orElse(null),
            platformVersion = javaType.platformVersion().map({ args0 -> args0 }).orElse(null),
            preBuildSteps = javaType.preBuildSteps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.PreBuildStepResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
