@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Policy that defines circuit breaker conditions
 * @property consecutiveErrors Number of consecutive errors before the circuit breaker opens
 * @property intervalInSeconds The time interval, in seconds, between endpoint checks. This can result in opening the circuit breaker if the check fails as well as closing the circuit breaker if the check succeeds. Defaults to 10s.
 * @property maxEjectionPercent Maximum percentage of hosts that will be ejected after failure threshold has been met
 */
public data class CircuitBreakerPolicyResponse(
    public val consecutiveErrors: Int? = null,
    public val intervalInSeconds: Int? = null,
    public val maxEjectionPercent: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CircuitBreakerPolicyResponse):
            CircuitBreakerPolicyResponse = CircuitBreakerPolicyResponse(
            consecutiveErrors = javaType.consecutiveErrors().map({ args0 -> args0 }).orElse(null),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
            maxEjectionPercent = javaType.maxEjectionPercent().map({ args0 -> args0 }).orElse(null),
        )
    }
}
