@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * HTTPGet specifies the http request to perform.
 * @property host Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
 * @property httpHeaders Custom headers to set in the request. HTTP allows repeated headers.
 * @property path Path to access on the HTTP server.
 * @property port Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 * @property scheme Scheme to use for connecting to the host. Defaults to HTTP.
 */
public data class ContainerAppProbeResponseHttpGet(
    public val host: String? = null,
    public val httpHeaders: List<ContainerAppProbeResponseHttpHeaders>? = null,
    public val path: String? = null,
    public val port: Int,
    public val scheme: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ContainerAppProbeResponseHttpGet):
            ContainerAppProbeResponseHttpGet = ContainerAppProbeResponseHttpGet(
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            httpHeaders = javaType.httpHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.app.kotlin.outputs.ContainerAppProbeResponseHttpHeaders.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
            scheme = javaType.scheme().map({ args0 -> args0 }).orElse(null),
        )
    }
}
