@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
 * @property host Optional: Host name to connect to, defaults to the pod IP.
 * @property port Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 */
public data class ContainerAppProbeResponseTcpSocket(
    public val host: String? = null,
    public val port: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ContainerAppProbeResponseTcpSocket):
            ContainerAppProbeResponseTcpSocket = ContainerAppProbeResponseTcpSocket(
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            port = javaType.port(),
        )
    }
}
