@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Model representing a mapping from a container registry to the identity used to connect to it.
 * @property containerRegistryServer Login server of the container registry.
 * @property identityResourceId Resource ID of the managed identity.
 */
public data class ContainerRegistryResponse(
    public val containerRegistryServer: String,
    public val identityResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.ContainerRegistryResponse):
            ContainerRegistryResponse = ContainerRegistryResponse(
            containerRegistryServer = javaType.containerRegistryServer(),
            identityResourceId = javaType.identityResourceId(),
        )
    }
}
