@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.app.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration properties for apps environment custom domain
 * @property certificatePassword Certificate password
 * @property certificateValue PFX or PEM blob
 * @property customDomainVerificationId Id used to verify domain name ownership
 * @property dnsSuffix Dns suffix for the environment domain
 * @property expirationDate Certificate expiration date.
 * @property subjectName Subject name of the certificate.
 * @property thumbprint Certificate thumbprint.
 */
public data class CustomDomainConfigurationResponse(
    public val certificatePassword: String? = null,
    public val certificateValue: String? = null,
    public val customDomainVerificationId: String,
    public val dnsSuffix: String? = null,
    public val expirationDate: String,
    public val subjectName: String,
    public val thumbprint: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.app.outputs.CustomDomainConfigurationResponse):
            CustomDomainConfigurationResponse = CustomDomainConfigurationResponse(
            certificatePassword = javaType.certificatePassword().map({ args0 -> args0 }).orElse(null),
            certificateValue = javaType.certificateValue().map({ args0 -> args0 }).orElse(null),
            customDomainVerificationId = javaType.customDomainVerificationId(),
            dnsSuffix = javaType.dnsSuffix().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate(),
            subjectName = javaType.subjectName(),
            thumbprint = javaType.thumbprint(),
        )
    }
}
